/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ec.notification.email;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mvel2.MVEL;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ec.notification.email.EmailAuthenticator;
import org.nuxeo.ecm.platform.ec.notification.email.NotificationsRenderingEngine;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationService;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;
import org.nuxeo.ecm.platform.rendering.RenderingException;
import org.nuxeo.ecm.platform.rendering.RenderingResult;
import org.nuxeo.ecm.platform.rendering.RenderingService;
import org.nuxeo.ecm.platform.rendering.impl.DocumentRenderingContext;
import org.nuxeo.runtime.api.Framework;

public class EmailHelper {
    private static final Log log = LogFactory.getLog(EmailHelper.class);
    private final Configuration stringCfg = new Configuration(Configuration.VERSION_2_3_0);
    protected static boolean javaMailNotAvailable = false;

    public void sendmail(Map<String, Object> mail) throws MessagingException {
        try {
            this.sendmail0(mail);
        }
        catch (TemplateException | IOException | LoginException | RenderingException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    protected void sendmail0(Map<String, Object> mail) throws MessagingException, IOException, TemplateException, LoginException, RenderingException {
        Collection<RenderingResult> results;
        LoginContext lc;
        Session session = EmailHelper.getSession();
        if (javaMailNotAvailable || session == null) {
            log.warn((Object)"Not sending email since JavaMail is not configured");
            return;
        }
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(session.getProperty("mail.from")));
        Object to = mail.get("mail.to");
        if (!(to instanceof String)) {
            log.error((Object)("Invalid email recipient: " + to));
            return;
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)((String)to), (boolean)false));
        RenderingService rs = (RenderingService)Framework.getService(RenderingService.class);
        DocumentRenderingContext context = new DocumentRenderingContext();
        context.remove("doc");
        context.putAll(mail);
        context.setDocument((DocumentModel)mail.get("document"));
        context.put("Runtime", Framework.getRuntime());
        String customSubjectTemplate = (String)mail.get("subjectTemplate");
        if (customSubjectTemplate == null) {
            String subjTemplate = (String)mail.get("subject");
            Template templ = new Template("name", (Reader)new StringReader(subjTemplate), this.stringCfg);
            StringWriter out = new StringWriter();
            templ.process(mail, (Writer)out);
            ((Writer)out).flush();
            msg.setSubject(((Object)out).toString(), "UTF-8");
        } else {
            rs.registerEngine(new NotificationsRenderingEngine(customSubjectTemplate));
            lc = Framework.login();
            results = rs.process(context);
            String subjectMail = "<HTML><P>No parsing Succeded !!!</P></HTML>";
            for (RenderingResult result : results) {
                subjectMail = (String)result.getOutcome();
            }
            subjectMail = NotificationServiceHelper.getNotificationService().getEMailSubjectPrefix() + subjectMail;
            msg.setSubject(subjectMail, "UTF-8");
            lc.logout();
        }
        msg.setSentDate(new Date());
        rs.registerEngine(new NotificationsRenderingEngine((String)mail.get("template")));
        lc = Framework.login();
        results = rs.process(context);
        String bodyMail = "<HTML><P>No parsing Succedeed !!!</P></HTML>";
        for (RenderingResult result : results) {
            bodyMail = (String)result.getOutcome();
        }
        lc.logout();
        rs.unregisterEngine("ftl");
        msg.setContent((Object)bodyMail, "text/html; charset=utf-8");
        Transport.send((Message)msg);
    }

    private static Session getSession() {
        Session session = null;
        if (javaMailNotAvailable) {
            return null;
        }
        try {
            NotificationService service = (NotificationService)((Object)Framework.getRuntime().getComponent(NotificationService.NAME));
            InitialContext ic = new InitialContext();
            session = (Session)ic.lookup(service.getMailSessionJndiName());
        }
        catch (NamingException ex) {
            log.warn((Object)"Unable to find Java mail API", (Throwable)ex);
            javaMailNotAvailable = true;
        }
        return session;
    }

    public static Session newSession(Properties props) {
        EmailAuthenticator authenticator = new EmailAuthenticator(props);
        Session session = Session.getInstance((Properties)props, (Authenticator)authenticator);
        String protocol = props.getProperty("mail.transport.protocol");
        if (protocol != null && protocol.length() > 0) {
            session.setProtocolForAddress("rfc822", protocol);
        }
        return session;
    }

    protected Map<String, Object> initMvelBindings(Map<String, Serializable> infos) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NotificationContext", infos);
        return map;
    }

    public String evaluateMvelExpresssion(String expr, Map<String, Serializable> ctx) {
        Serializable compiledExpr = MVEL.compileExpression((String)expr);
        Object result = MVEL.executeExpression((Object)compiledExpr, this.initMvelBindings(ctx));
        if (result instanceof String) {
            return (String)result;
        }
        return null;
    }
}

