/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.international.LocaleSelector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.impl.VersionModelImpl;
import org.nuxeo.ecm.diff.content.ContentDiffHelper;
import org.nuxeo.ecm.diff.model.DiffDisplayBlock;
import org.nuxeo.ecm.diff.model.DifferenceType;
import org.nuxeo.ecm.diff.model.DocumentDiff;
import org.nuxeo.ecm.diff.service.DiffDisplayService;
import org.nuxeo.ecm.diff.service.DocumentDiffService;
import org.nuxeo.ecm.diff.web.DiffSelectionType;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.versioning.VersionedActions;
import org.nuxeo.runtime.api.Framework;

@Name(value="diffActions")
@Scope(value=ScopeType.CONVERSATION)
public class DiffActionsBean
implements Serializable {
    private static final long serialVersionUID = -5507491210664361778L;
    private static final Log log = LogFactory.getLog(DiffActionsBean.class);
    private static final String DOC_DIFF_VIEW = "view_doc_diff";
    private static final String CONTENT_DIFF_DIFFERENCE_TYPE_MSG_KEY_PREFIX = "diff.content.differenceType.message.";
    private static final String LAST_VERSION_PROPERTY = "lastVersion";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient DocumentsListsManager documentsListsManager;
    @In(create=true, required=false)
    protected transient VersionedActions versionedActions;
    @In(create=true)
    protected transient LocaleSelector localeSelector;
    protected DocumentModel leftDoc;
    protected DocumentModel rightDoc;
    protected String selectedVersionId;
    protected String diffSelectionType = DiffSelectionType.content.name();

    public boolean getCanDiffCurrentDocumentSelection() {
        return this.getCanDiffWorkingList("CURRENT_SELECTION");
    }

    public boolean getCanDiffCurrentTrashSelection() {
        return this.getCanDiffWorkingList("CURRENT_SELECTION_TRASH");
    }

    public boolean getCanDiffCurrentSectionSelection() {
        return this.getCanDiffWorkingList("CURRENT_SELECTION_SECTIONS");
    }

    public boolean getCanDiffCurrentVersionSelection() {
        return this.getCanDiffWorkingList("CURRENT_SELECTION_VERSIONS");
    }

    public boolean getCanDiffCurrentDefaultSelection() {
        return this.getCanDiffWorkingList("DEFAULT");
    }

    public boolean getCanDiffWorkingList(String listName) {
        List currentSelectionWorkingList = this.documentsListsManager.getWorkingList(listName);
        return currentSelectionWorkingList != null && currentSelectionWorkingList.size() == 2;
    }

    public String prepareCurrentDocumentSelectionDiff() {
        this.diffSelectionType = DiffSelectionType.content.name();
        return this.prepareWorkingListDiff("CURRENT_SELECTION");
    }

    public String prepareCurrentTrashSelectionDiff() {
        this.diffSelectionType = DiffSelectionType.trash.name();
        return this.prepareWorkingListDiff("CURRENT_SELECTION_TRASH");
    }

    public String prepareCurrentSectionSelectionDiff() {
        this.diffSelectionType = DiffSelectionType.content.name();
        return this.prepareWorkingListDiff("CURRENT_SELECTION_SECTIONS");
    }

    public String prepareCurrentVersionSelectionDiff() {
        this.diffSelectionType = DiffSelectionType.version.name();
        return this.prepareWorkingListDiff("CURRENT_SELECTION_VERSIONS");
    }

    public String prepareCurrentDefaultSelectionDiff() {
        this.diffSelectionType = DiffSelectionType.content.name();
        return this.prepareWorkingListDiff("DEFAULT");
    }

    public String prepareWorkingListDiff(String listName) {
        List<DocumentModel> workingList = this.getWorkingList(listName);
        this.leftDoc = workingList.get(0);
        this.rightDoc = workingList.get(1);
        return this.refresh();
    }

    public String prepareCurrentVersionDiff(String versionLabel) {
        DocumentModel documentVersion;
        DocumentModel currentDocument;
        if (StringUtils.isBlank((CharSequence)versionLabel)) {
            versionLabel = LAST_VERSION_PROPERTY;
        }
        if ((currentDocument = this.navigationContext.getCurrentDocument()).isVersion()) {
            log.info((Object)"Unable to diff, current document is a version document");
            return null;
        }
        if (LAST_VERSION_PROPERTY.equals(versionLabel)) {
            documentVersion = this.documentManager.getLastDocumentVersion(currentDocument.getRef());
            if (documentVersion == null) {
                log.info((Object)"Unable to diff, current document do not have any versions yet.");
                return null;
            }
        } else {
            VersionModelImpl versionModel = new VersionModelImpl();
            versionModel.setLabel(versionLabel);
            documentVersion = this.documentManager.getDocumentWithVersion(currentDocument.getRef(), (VersionModel)versionModel);
            if (documentVersion == null) {
                log.info((Object)("Unable to found " + versionLabel + " on current document to diff."));
                return null;
            }
        }
        this.setLeftDoc(currentDocument);
        this.setRightDoc(documentVersion);
        this.diffSelectionType = DiffSelectionType.version.name();
        return DOC_DIFF_VIEW;
    }

    public String prepareCurrentVersionDiff() {
        String selectedVersionId = this.versionedActions.getSelectedVersionId();
        if (selectedVersionId != null) {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            if (currentDocument == null) {
                throw new NuxeoException("Cannot make a diff between selected version and current document since current document is null.");
            }
            VersionModelImpl selectedVersion = new VersionModelImpl();
            selectedVersion.setId(selectedVersionId);
            DocumentModel docVersion = this.documentManager.getDocumentWithVersion(currentDocument.getRef(), (VersionModel)selectedVersion);
            if (docVersion == null) {
                throw new NuxeoException("Cannot make a diff between selected version and current document since selected version document is null.");
            }
            this.leftDoc = docVersion;
            this.rightDoc = currentDocument;
            this.diffSelectionType = DiffSelectionType.version.name();
            return DOC_DIFF_VIEW;
        }
        return null;
    }

    public String refresh() {
        if (this.isDocumentDiffAvailable()) {
            this.leftDoc = this.documentManager.getDocument(this.leftDoc.getRef());
            this.rightDoc = this.documentManager.getDocument(this.rightDoc.getRef());
        }
        return DOC_DIFF_VIEW;
    }

    public boolean isDocumentDiffAvailable() {
        return this.leftDoc != null && this.rightDoc != null;
    }

    @Factory(value="defaultDiffDisplayBlocks", scope=ScopeType.PAGE)
    public List<DiffDisplayBlock> getDefaultDiffDisplayBlocks() {
        if (this.leftDoc == null || this.rightDoc == null) {
            return new ArrayList<DiffDisplayBlock>();
        }
        DocumentDiff docDiff = this.getDocumentDiffService().diff(this.documentManager, this.leftDoc, this.rightDoc);
        return this.getDiffDisplayService().getDiffDisplayBlocks(docDiff, this.leftDoc, this.rightDoc);
    }

    public String getContentDiffFancyBoxURL(String propertyLabel, String propertyXPath) {
        return this.getContentDiffFancyBoxURL(propertyLabel, propertyXPath, null);
    }

    public String getContentDiffFancyBoxURL(String propertyLabel, String propertyXPath, String conversionType) {
        if (StringUtils.isEmpty((CharSequence)propertyXPath)) {
            log.error((Object)"Cannot get content diff fancybox URL with a null propertyXPath.");
            return null;
        }
        return ContentDiffHelper.getContentDiffFancyBoxURL((DocumentModel)this.navigationContext.getCurrentDocument(), (String)propertyLabel, (String)propertyXPath, (String)conversionType);
    }

    public String getContentDiffURL(String docLeftId, String docRightId, String propertyXPath, String conversionTypeParam) {
        DocumentModel leftDoc = null;
        DocumentModel rightDoc = null;
        if (!StringUtils.isBlank((CharSequence)docLeftId)) {
            leftDoc = this.documentManager.getDocument((DocumentRef)new IdRef(docLeftId));
        }
        if (!StringUtils.isBlank((CharSequence)docRightId)) {
            rightDoc = this.documentManager.getDocument((DocumentRef)new IdRef(docRightId));
        }
        if (rightDoc == null || leftDoc == null) {
            log.error((Object)"Cannot get content diff URL with a null leftDoc or a null rightDoc.");
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)propertyXPath)) {
            log.error((Object)"Cannot get content diff URL with a null schemaName or a null fieldName.");
            return null;
        }
        String conversionType = null;
        if (!StringUtils.isEmpty((CharSequence)conversionTypeParam)) {
            conversionType = conversionTypeParam;
        }
        return ContentDiffHelper.getContentDiffURL((String)this.navigationContext.getCurrentDocument().getRepositoryName(), (DocumentModel)leftDoc, (DocumentModel)rightDoc, (String)propertyXPath, (String)conversionType, (String)this.localeSelector.getLocaleString());
    }

    public String getContentDiffURL(String propertyXPath, String conversionTypeParam) {
        if (this.leftDoc == null || this.rightDoc == null) {
            log.error((Object)"Cannot get content diff URL with a null leftDoc or a null rightDoc.");
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)propertyXPath)) {
            log.error((Object)"Cannot get content diff URL with a null schemaName or a null fieldName.");
            return null;
        }
        String conversionType = null;
        if (!StringUtils.isEmpty((CharSequence)conversionTypeParam)) {
            conversionType = conversionTypeParam;
        }
        return ContentDiffHelper.getContentDiffURL((String)this.navigationContext.getCurrentDocument().getRepositoryName(), (DocumentModel)this.leftDoc, (DocumentModel)this.rightDoc, (String)propertyXPath, (String)conversionType, (String)this.localeSelector.getLocaleString());
    }

    public String getContentDiffWithBlobPostProcessingURL(String propertyXPath, String conversionTypeParam) {
        return this.getContentDiffURL(propertyXPath, conversionTypeParam) + "?blobPostProcessing=true";
    }

    public boolean isDifferentFilename(DifferenceType differenceType) {
        return DifferenceType.differentFilename.equals((Object)differenceType);
    }

    public String getContentDiffDifferenceTypeMsgKey(DifferenceType differenceType) {
        return CONTENT_DIFF_DIFFERENCE_TYPE_MSG_KEY_PREFIX + differenceType.name();
    }

    protected final List<DocumentModel> getWorkingList(String listName) {
        List currentSelectionWorkingList = this.documentsListsManager.getWorkingList(listName);
        if (currentSelectionWorkingList == null || currentSelectionWorkingList.size() != 2) {
            throw new NuxeoException(String.format("Cannot make a diff of the %s working list: need to have exactly 2 documents in the working list.", listName));
        }
        return currentSelectionWorkingList;
    }

    protected final DocumentDiffService getDocumentDiffService() {
        return (DocumentDiffService)Framework.getService(DocumentDiffService.class);
    }

    protected final DiffDisplayService getDiffDisplayService() {
        return (DiffDisplayService)Framework.getService(DiffDisplayService.class);
    }

    public DocumentModel getLeftDoc() {
        return this.leftDoc;
    }

    public void setLeftDoc(DocumentModel leftDoc) {
        this.leftDoc = leftDoc;
    }

    public DocumentModel getRightDoc() {
        return this.rightDoc;
    }

    public void setRightDoc(DocumentModel rightDoc) {
        this.rightDoc = rightDoc;
    }

    public String getDiffSelectionType() {
        return this.diffSelectionType;
    }

    public void setDiffSelectionType(String diffSelectionType) {
        this.diffSelectionType = diffSelectionType;
    }
}

