/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.blobholder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.AbstractBlobHolder;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.utils.BlobsExtractor;

public class DocumentBlobHolder
extends AbstractBlobHolder {
    protected final DocumentModel doc;
    protected final String xPath;
    protected List<Blob> blobList = null;

    public DocumentBlobHolder(DocumentModel doc, String xPath) {
        if (xPath == null) {
            throw new IllegalArgumentException("Invalid null xpath for document: " + doc);
        }
        this.doc = doc;
        this.xPath = xPath;
    }

    protected DocumentBlobHolder(DocumentModel doc, String xPath, List<Blob> blobList) {
        this(doc, xPath);
        this.blobList = blobList;
    }

    @Override
    protected String getBasePath() {
        return this.doc.getPathAsString();
    }

    @Override
    public Blob getBlob() {
        return (Blob)((Object)this.doc.getPropertyValue(this.xPath));
    }

    @Override
    public void setBlob(Blob blob) {
        this.doc.getProperty(this.xPath).setValue(blob);
    }

    @Override
    public Calendar getModificationDate() {
        return (Calendar)this.doc.getProperty("dublincore", "modified");
    }

    @Override
    public String getHash() {
        String h;
        Blob blob = this.getBlob();
        if (blob != null && (h = blob.getDigest()) != null) {
            return h;
        }
        return this.doc.getId() + this.xPath + String.valueOf(this.getModificationDate());
    }

    @Override
    public Serializable getProperty(String name) {
        return null;
    }

    @Override
    public Map<String, Serializable> getProperties() {
        return null;
    }

    @Override
    public List<Blob> getBlobs() {
        if (this.blobList == null) {
            this.computeBlobList();
        }
        return this.blobList;
    }

    public DocumentBlobHolder asDirectBlobHolder(int index) throws IndexOutOfBoundsException {
        List<Property> properties = this.computeBlobList();
        String xpath = this.getFullXPath(properties.get(index));
        return new DocumentBlobHolder(this.doc, xpath, this.blobList);
    }

    protected List<Property> computeBlobList() {
        Property property;
        List<Property> properties = new BlobsExtractor().getBlobsProperties(this.doc);
        Iterator<Property> it = properties.iterator();
        boolean hasMainBlob = false;
        while (it.hasNext()) {
            property = it.next();
            if (!this.getFullXPath(property).equals(this.xPath)) continue;
            it.remove();
            properties.add(0, property);
            hasMainBlob = true;
            break;
        }
        if (!hasMainBlob) {
            property = this.doc.getProperty(this.xPath);
            properties.add(0, property);
        }
        this.blobList = new ArrayList<Blob>(properties.size());
        for (int i = 0; i < properties.size(); ++i) {
            if (i == 0) {
                Blob mainBlob = this.getBlob();
                if (mainBlob == null) continue;
                this.blobList.add(mainBlob);
                continue;
            }
            this.blobList.add((Blob)((Object)properties.get(i).getValue()));
        }
        return properties;
    }

    protected String getFullXPath(Property property) {
        String xpath = property.getXPath();
        if (xpath.indexOf(58) < 0) {
            xpath = property.getSchema().getName() + ':' + xpath;
        }
        return xpath;
    }

    public String getXpath() {
        return this.xPath;
    }

    public DocumentModel getDocument() {
        return this.doc;
    }
}

