/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl.blob;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.impl.blob.AbstractBlob;

public class StringBlob
extends AbstractBlob
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(StringBlob.class);
    protected final String string;

    public StringBlob(String content) {
        this(content, "text/plain", "UTF-8");
    }

    public StringBlob(String string, String mimeType) {
        this(string, mimeType, "UTF-8");
    }

    public StringBlob(String string, String mimeType, String encoding) {
        if (string == null) {
            throw new NullPointerException("null string");
        }
        this.string = string;
        this.mimeType = mimeType;
        this.encoding = encoding;
    }

    public StringBlob(String string, String mimeType, String encoding, String filename) {
        this(string, mimeType, encoding);
        this.setFilename(filename);
    }

    @Override
    public long getLength() {
        try {
            return this.getByteArray().length;
        }
        catch (IOException e) {
            log.error((Object)("Error while getting byte array from blob, returning -1: " + this.getFilename()));
            return -1L;
        }
    }

    @Override
    public InputStream getStream() throws IOException {
        return new ByteArrayInputStream(this.getByteArray());
    }

    @Override
    public byte[] getByteArray() throws IOException {
        return this.string.getBytes(this.getEncoding() == null ? UTF_8 : this.getEncoding());
    }

    @Override
    public String getString() {
        return this.string;
    }
}

