/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl;

import java.io.Serializable;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyConversionException;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.ReadOnlyPropertyException;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.RemovedProperty;
import org.nuxeo.ecm.core.api.model.resolver.PropertyObjectResolver;
import org.nuxeo.ecm.core.api.model.resolver.PropertyObjectResolverImpl;
import org.nuxeo.ecm.core.schema.PropertyDeprecationHandler;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolver;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractProperty
implements Property {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractProperty.class);
    protected static final Pattern NON_CANON_INDEX = Pattern.compile("[^/\\[\\]]+\\[(-?\\d+)\\]");
    public static final int IS_READONLY = 32;
    public final Property parent;
    public boolean forceDirty = false;
    protected int flags;
    protected Boolean isDeprecated;
    protected Property deprecatedFallback;

    protected AbstractProperty(Property parent) {
        this.parent = parent;
    }

    protected AbstractProperty(Property parent, int flags) {
        this.parent = parent;
        this.flags = flags;
    }

    public abstract void internalSetValue(Serializable var1) throws PropertyException;

    public abstract Serializable internalGetValue() throws PropertyException;

    @Override
    public void init(Serializable value) throws PropertyException {
        if (value == null || value instanceof Object[] && ((Object[])value).length == 0) {
            return;
        }
        this.internalSetValue(value);
        this.removePhantomFlag();
    }

    public void removePhantomFlag() {
        this.flags &= 0xFFFFFFEF;
        if (this.parent != null) {
            ((AbstractProperty)this.parent).removePhantomFlag();
        }
    }

    @Override
    public void setValue(int index, Object value) throws PropertyException {
        Property property = this.get(index);
        property.setValue(value);
    }

    @Override
    public int size() {
        return this.getChildren().size();
    }

    @Override
    public Iterator<Property> iterator() {
        return this.getChildren().iterator();
    }

    @Override
    public Serializable remove() throws PropertyException {
        Serializable value = this.getValue();
        if (this.parent != null && this.parent.isList()) {
            ListProperty list = (ListProperty)this.parent;
            list.remove(this);
        } else if (!this.isPhantom()) {
            Serializable previous = this.internalGetValue();
            this.init(null);
            if (previous != null || this.isForceDirty()) {
                this.setIsRemoved();
            }
        }
        return value;
    }

    @Override
    public Property getParent() {
        return this.parent;
    }

    @Override
    public String getXPath() {
        StringBuilder buf = new StringBuilder();
        this.getXPath(buf);
        return buf.toString();
    }

    protected void getXPath(StringBuilder buf) {
        if (this.parent != null) {
            ((AbstractProperty)this.parent).getXPath(buf);
            if (this.parent.isList()) {
                buf.append('/');
                int i = ((ListProperty)this.parent).children.indexOf(this);
                buf.append(i);
            } else {
                if (buf.length() != 0) {
                    buf.append('/');
                }
                buf.append(this.getName());
            }
        }
    }

    @Override
    @Deprecated
    public String getPath() {
        Path path = this.collectPath(new Path("/"));
        return path.toString();
    }

    protected Path collectPath(Path path) {
        String name = this.getName();
        if (this.parent != null) {
            if (this.parent.isList()) {
                int i = ((ListProperty)this.parent).children.indexOf(this);
                name = name + '[' + i + ']';
            }
            path = ((AbstractProperty)this.parent).collectPath(path);
        }
        return path.append(name);
    }

    @Override
    public Schema getSchema() {
        return this.getRoot().getSchema();
    }

    @Override
    public boolean isList() {
        return this.getType().isListType();
    }

    @Override
    public boolean isComplex() {
        return this.getType().isComplexType();
    }

    @Override
    public boolean isScalar() {
        return this.getType().isSimpleType();
    }

    @Override
    public boolean isNew() {
        return this.areFlagsSet(1L);
    }

    @Override
    public boolean isRemoved() {
        return this.areFlagsSet(4L);
    }

    @Override
    public boolean isMoved() {
        return this.areFlagsSet(8L);
    }

    @Override
    public boolean isModified() {
        return this.areFlagsSet(2L);
    }

    @Override
    public boolean isPhantom() {
        return this.areFlagsSet(16L);
    }

    @Override
    public final boolean isDirty() {
        return (this.flags & 0xF) != 0;
    }

    protected final void setDirtyFlags(int dirtyFlags) {
        this.flags = dirtyFlags & 0x1F | this.flags & 0xFFFFFFE0;
    }

    protected final void appendDirtyFlags(int dirtyFlags) {
        this.flags |= dirtyFlags & 0x1F;
    }

    @Override
    public boolean isReadOnly() {
        return this.areFlagsSet(32L);
    }

    @Override
    public void setReadOnly(boolean value) {
        if (value) {
            this.setFlags(32L);
        } else {
            this.clearFlags(32L);
        }
    }

    public final boolean areFlagsSet(long flags) {
        return ((long)this.flags & flags) != 0L;
    }

    public final void setFlags(long flags) {
        this.flags = (int)((long)this.flags | flags);
    }

    public final void clearFlags(long flags) {
        this.flags = (int)((long)this.flags & (flags ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public int getDirtyFlags() {
        return this.flags & 0x1F;
    }

    @Override
    public void clearDirtyFlags() {
        if ((this.flags & 4) != 0) {
            this.setDirtyFlags(16);
        } else {
            this.setDirtyFlags(0);
        }
    }

    public void setIsModified() {
        if ((this.flags & 2) == 0) {
            this.flags |= 2;
            this.flags &= 0xFFFFFFEF;
        }
        if (this.parent != null) {
            ((AbstractProperty)this.parent).setIsModified();
        }
    }

    protected void setIsNew() {
        if (this.isDirty()) {
            throw new IllegalStateException("Cannot set IS_NEW flag on a dirty property");
        }
        this.setDirtyFlags(1);
        if (this.parent != null) {
            ((AbstractProperty)this.parent).setIsModified();
        }
    }

    protected void setIsRemoved() {
        if (this.isPhantom() || this.parent == null || this.parent.isList()) {
            throw new IllegalStateException("Cannot set IS_REMOVED on removed or properties that are not map elements");
        }
        if ((this.flags & 4) == 0) {
            this.setDirtyFlags(4);
            ((AbstractProperty)this.parent).setIsModified();
        }
    }

    protected void setIsMoved() {
        if (this.parent == null || !this.parent.isList()) {
            throw new IllegalStateException("Cannot set IS_MOVED on removed or properties that are not map elements");
        }
        if ((this.flags & 8) == 0) {
            this.flags |= 8;
            ((AbstractProperty)this.parent).setIsModified();
        }
    }

    protected boolean isDeprecated() {
        if (this.isDeprecated == null) {
            boolean deprecated = false;
            if (this.parent instanceof AbstractProperty) {
                AbstractProperty absParent = (AbstractProperty)this.parent;
                deprecated = absParent.isDeprecated();
                Property parentDeprecatedFallback = absParent.deprecatedFallback;
                if (deprecated && parentDeprecatedFallback != null) {
                    this.deprecatedFallback = parentDeprecatedFallback.resolvePath(this.getName());
                }
            }
            if (!deprecated) {
                String fallback;
                String name = this.getXPath();
                String schema = this.getSchema().getName();
                SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
                PropertyDeprecationHandler deprecatedProperties = schemaManager.getDeprecatedProperties();
                deprecated = deprecatedProperties.isMarked(schema, name);
                if (deprecated && (fallback = deprecatedProperties.getFallback(schema, name)) != null) {
                    this.deprecatedFallback = this.resolvePath('/' + fallback);
                }
            }
            this.isDeprecated = deprecated;
        }
        return this.isDeprecated;
    }

    @Override
    public <T> T getValue(Class<T> type) throws PropertyException {
        return this.convertTo(this.getValue(), type);
    }

    @Override
    public void setValue(Object value) throws PropertyException {
        Serializable current;
        if (this.isReadOnly()) {
            throw new ReadOnlyPropertyException(this.getXPath());
        }
        Serializable normalizedValue = this.normalize(value);
        if (!this.isSameValue(normalizedValue, current = this.internalGetValue()) || this.isForceDirty()) {
            this.internalSetValue(normalizedValue);
            this.setValueDeprecation(normalizedValue, true);
            this.setIsModified();
        } else {
            this.removePhantomFlag();
        }
    }

    protected void setValueDeprecation(Object value, boolean setFallback) throws PropertyException {
        if (this.isDeprecated()) {
            if (setFallback && this.deprecatedFallback != null) {
                this.deprecatedFallback.setValue(value);
            }
            if (log.isWarnEnabled()) {
                StringBuilder msg = this.newDeprecatedMessage();
                msg.append("Set value to deprecated property");
                if (this.deprecatedFallback != null) {
                    msg.append(" and to fallback property '").append(this.deprecatedFallback.getXPath()).append("'");
                }
                if (log.isTraceEnabled()) {
                    log.warn((Object)msg, (Throwable)new NuxeoException("debug stack trace"));
                } else {
                    log.warn((Object)msg);
                }
            }
        }
    }

    protected boolean isSameValue(Serializable value1, Serializable value2) {
        return value1 == null && value2 == null || value1 != null && value1.equals(value2);
    }

    @Override
    public void setValue(String path, Object value) throws PropertyException {
        this.resolvePath(path).setValue(value);
    }

    @Override
    public <T> T getValue(Class<T> type, String path) throws PropertyException {
        return this.resolvePath(path).getValue(type);
    }

    @Override
    public Serializable getValue(String path) throws PropertyException {
        return this.resolvePath(path).getValue();
    }

    @Override
    public Serializable getValue() throws PropertyException {
        if (this.isPhantom() || this.isRemoved()) {
            return this.getDefaultValue();
        }
        Serializable fallbackValue = this.getValueDeprecation();
        return fallbackValue == null ? this.internalGetValue() : fallbackValue;
    }

    protected Serializable getValueDeprecation() {
        if (this.isDeprecated()) {
            if (log.isWarnEnabled()) {
                StringBuilder msg = this.newDeprecatedMessage();
                if (this.deprecatedFallback == null) {
                    msg.append("Return value from deprecated property");
                } else {
                    msg.append("Return value from '").append(this.deprecatedFallback.getXPath()).append("' if not null, from deprecated property otherwise");
                }
                if (log.isTraceEnabled()) {
                    log.warn((Object)msg, (Throwable)new NuxeoException());
                } else {
                    log.warn((Object)msg);
                }
            }
            if (this.deprecatedFallback != null) {
                return this.deprecatedFallback.getValue();
            }
        }
        return null;
    }

    protected StringBuilder newDeprecatedMessage() {
        StringBuilder builder = new StringBuilder().append("Property '").append(this.getXPath()).append("' is marked as deprecated from '").append(this.getSchema().getName()).append("' schema");
        AbstractProperty deprecatedParent = this.getDeprecatedParent();
        if (deprecatedParent != this) {
            builder.append(" because property '").append(deprecatedParent.getXPath()).append("' is marked as deprecated");
        }
        return builder.append(", don't use it anymore. ");
    }

    protected AbstractProperty getDeprecatedParent() {
        AbstractProperty absParent;
        if (this.parent instanceof AbstractProperty && (absParent = (AbstractProperty)this.parent).isDeprecated()) {
            return absParent.getDeprecatedParent();
        }
        return this;
    }

    @Override
    public Serializable getValueForWrite() throws PropertyException {
        return this.getValue();
    }

    protected Serializable getDefaultValue() {
        return (Serializable)this.getField().getDefaultValue();
    }

    @Override
    public void moveTo(int index) {
        if (this.parent == null || !this.parent.isList()) {
            throw new UnsupportedOperationException("Not a list item property");
        }
        ListProperty list = (ListProperty)this.parent;
        if (list.moveTo(this, index)) {
            this.setIsMoved();
        }
    }

    @Override
    public DocumentPart getRoot() {
        return this.parent == null ? (DocumentPart)((Object)this) : this.parent.getRoot();
    }

    @Override
    public Property resolvePath(String path) throws PropertyNotFoundException {
        return this.resolvePath(new Path(path));
    }

    @Override
    public Property resolvePath(Path path) throws PropertyNotFoundException {
        if (path.isAbsolute()) {
            return this.getRoot().resolvePath(path.makeRelative());
        }
        String[] segments = path.segments();
        Property property = this;
        for (int start = 0; start < segments.length && segments[start].equals(".."); ++start) {
            property = property.getParent();
        }
        for (int i = start; i < segments.length; ++i) {
            String segment = segments[i];
            if (property.isScalar()) {
                throw new PropertyNotFoundException(path.toString(), "segment " + segment + " points to a scalar property");
            }
            String index = null;
            if (segment.endsWith("]")) {
                int p = segment.lastIndexOf(91);
                if (p == -1) {
                    throw new PropertyNotFoundException(path.toString(), "Parse error: no matching '[' was found");
                }
                index = segment.substring(p + 1, segment.length() - 1);
            }
            if (index == null) {
                if ((property = property.get(segment)) != null) continue;
                throw new PropertyNotFoundException(path.toString(), "segment " + segment + " cannot be resolved");
            }
            property = property.get(index);
        }
        return property;
    }

    protected Property computeRemovedProperty(String name) {
        String schema = this.getSchema().getName();
        String originalXpath = this.collectPath(new Path("/")).append(name).toString().substring(1);
        String xpath = originalXpath.indexOf(91) != -1 ? NON_CANON_INDEX.matcher(originalXpath).replaceAll("*") : originalXpath;
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        PropertyDeprecationHandler removedProperties = schemaManager.getRemovedProperties();
        if (!removedProperties.isMarked(schema, xpath)) {
            return null;
        }
        String fallback = removedProperties.getFallback(schema, xpath);
        if (fallback == null) {
            return new RemovedProperty((Property)this, name);
        }
        Matcher matcher = NON_CANON_INDEX.matcher(originalXpath);
        while (matcher.find()) {
            fallback = fallback.replaceFirst("\\*", matcher.group(0));
        }
        int i = fallback.lastIndexOf("[-1]");
        Property fallbackProperty = i != -1 ? this.get(fallback.substring(i + 5)) : this.resolvePath('/' + fallback);
        return new RemovedProperty(this, name, fallbackProperty);
    }

    @Override
    public Serializable normalize(Object value) throws PropertyConversionException {
        if (this.isNormalized(value)) {
            return (Serializable)value;
        }
        throw new PropertyConversionException(value.getClass(), Serializable.class, this.getXPath());
    }

    @Override
    public boolean isNormalized(Object value) {
        return value == null || value instanceof Serializable;
    }

    @Override
    public <T> T convertTo(Serializable value, Class<T> toType) throws PropertyConversionException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean validateType(Class<?> type) {
        return true;
    }

    @Override
    public Object newInstance() {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getXPath() + ')';
    }

    @Override
    public PropertyObjectResolver getObjectResolver() {
        ObjectResolver resolver = this.getType().getObjectResolver();
        if (resolver != null) {
            return new PropertyObjectResolverImpl(this, resolver);
        }
        return null;
    }

    @Override
    public boolean isForceDirty() {
        return this.forceDirty;
    }

    @Override
    public void setForceDirty(boolean forceDirty) {
        this.forceDirty = forceDirty;
    }
}

