/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.security.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.api.security.UserEntry;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;

public class ACPImpl
implements ACP {
    private static final long serialVersionUID = 1L;
    private final List<ACL> acls = new ArrayList<ACL>();
    private transient Map<String, Access> cache = new HashMap<String, Access>();

    @Override
    public void addACL(ACL acl) {
        assert (acl != null);
        ACL oldACL = this.getACL(acl.getName());
        if (!acl.equals(oldACL)) {
            if (oldACL != null) {
                oldACL.clear();
                oldACL.addAll(acl);
            } else {
                String name;
                switch (name = acl.getName()) {
                    case "inherited": {
                        this.acls.add(acl);
                        break;
                    }
                    case "local": {
                        ACL inherited = this.getACL("inherited");
                        if (inherited != null) {
                            int i = this.acls.indexOf(inherited);
                            this.acls.add(i, acl);
                            break;
                        }
                        this.acls.add(acl);
                        break;
                    }
                    default: {
                        ACL local = this.getACL("local");
                        if (local != null) {
                            int i = this.acls.indexOf(local);
                            this.acls.add(i, acl);
                            break;
                        }
                        ACL inherited = this.getACL("inherited");
                        if (inherited != null) {
                            int i = this.acls.indexOf(inherited);
                            this.acls.add(i, acl);
                            break;
                        }
                        this.acls.add(acl);
                    }
                }
            }
        }
        this.cache.clear();
    }

    @Override
    public void addACL(int pos, ACL acl) {
        ACL oldACL = this.getACL(acl.getName());
        if (oldACL != null) {
            this.acls.remove(oldACL);
        }
        this.acls.add(pos, acl);
        this.cache.clear();
    }

    @Override
    public void addACL(String afterMe, ACL acl) {
        if (afterMe == null) {
            this.addACL(0, acl);
        } else {
            int i;
            int len = this.acls.size();
            for (i = 0; i < len && !this.acls.get(i).getName().equals(afterMe); ++i) {
            }
            this.addACL(i + 1, acl);
        }
    }

    @Override
    public ACL getACL(String name) {
        String localName = name == null ? "local" : name;
        return this.acls.stream().filter(acl -> acl.getName().equals(localName)).findFirst().orElse(null);
    }

    @Override
    public ACL[] getACLs() {
        return this.acls.toArray(new ACL[this.acls.size()]);
    }

    @Override
    public ACL getMergedACLs(String name) {
        ACLImpl mergedAcl = new ACLImpl(name, true);
        for (ACL acl : this.acls) {
            mergedAcl.addAll(acl);
        }
        return mergedAcl;
    }

    public static ACL newACL(String name) {
        return new ACLImpl(name);
    }

    @Override
    public ACL removeACL(String name) {
        int len = this.acls.size();
        for (int i = 0; i < len; ++i) {
            ACL acl = this.acls.get(i);
            if (!acl.getName().equals(name)) continue;
            this.cache.clear();
            return this.acls.remove(i);
        }
        return null;
    }

    @Override
    public Access getAccess(String principal, String permission) {
        String key = principal + ':' + permission;
        Access access = this.cache.get(key);
        if (access == null) {
            access = Access.UNKNOWN;
            block0: for (ACL acl : this.acls) {
                for (ACE ace : acl) {
                    if (!ACPImpl.permissionsMatch(ace, permission) || !ACPImpl.principalsMatch(ace, principal)) continue;
                    access = ace.isGranted() ? Access.GRANT : Access.DENY;
                    break block0;
                }
            }
            this.cache.put(key, access);
        }
        return access;
    }

    @Override
    public Access getAccess(String[] principals, String[] permissions) {
        for (ACL acl : this.acls) {
            for (ACE ace : acl) {
                Access access;
                if (!ace.isEffective() || (access = ACPImpl.getAccess(ace, principals, permissions)) == Access.UNKNOWN) continue;
                return access;
            }
        }
        return Access.UNKNOWN;
    }

    public static Access getAccess(ACE ace, String[] principals, String[] permissions) {
        String acePerm = ace.getPermission();
        String aceUser = ace.getUsername();
        for (String principal : principals) {
            if (!ACPImpl.principalsMatch(aceUser, principal)) continue;
            for (String permission : permissions) {
                if (!ACPImpl.permissionsMatch(acePerm, permission)) continue;
                return ace.isGranted() ? Access.GRANT : Access.DENY;
            }
        }
        return Access.UNKNOWN;
    }

    private static boolean permissionsMatch(ACE ace, String permission) {
        String acePerm = ace.getPermission();
        if (!"RestrictedRead".equals(permission) && "Everything".equals(acePerm)) {
            return true;
        }
        return StringUtils.equals((CharSequence)acePerm, (CharSequence)permission);
    }

    private static boolean permissionsMatch(String acePerm, String permission) {
        if ("Everything".equals(acePerm) && !"RestrictedRead".equals(permission)) {
            return true;
        }
        return StringUtils.equals((CharSequence)acePerm, (CharSequence)permission);
    }

    private static boolean principalsMatch(ACE ace, String principal) {
        String acePrincipal = ace.getUsername();
        if ("Everyone".equals(acePrincipal)) {
            return true;
        }
        return StringUtils.equals((CharSequence)acePrincipal, (CharSequence)principal);
    }

    private static boolean principalsMatch(String acePrincipal, String principal) {
        if ("Everyone".equals(acePrincipal)) {
            return true;
        }
        return StringUtils.equals((CharSequence)acePrincipal, (CharSequence)principal);
    }

    public void addAccessRule(String aclName, ACE ace) {
        ACL acl = this.getACL(aclName);
        if (acl == null) {
            acl = new ACLImpl(aclName);
            this.addACL(acl);
        }
        acl.add(ace);
    }

    @Override
    public ACL getOrCreateACL(String name) {
        ACL acl = this.getACL(name);
        if (acl == null) {
            acl = new ACLImpl(name);
            this.addACL(acl);
        }
        return acl;
    }

    @Override
    public ACL getOrCreateACL() {
        return this.getOrCreateACL("local");
    }

    @Override
    public void setRules(String aclName, UserEntry[] userEntries) {
        this.setRules(aclName, userEntries, true);
    }

    @Override
    public void setRules(String aclName, UserEntry[] userEntries, boolean overwrite) {
        ACL acl = this.getACL(aclName);
        if (acl == null) {
            acl = new ACLImpl(aclName);
            this.addACL(acl);
        } else if (overwrite) {
            acl.clear();
        }
        for (UserEntry entry : userEntries) {
            String username = entry.getUserName();
            for (String permission : entry.getGrantedPermissions()) {
                acl.add(new ACE(username, permission, true));
            }
            for (String permission : entry.getDeniedPermissions()) {
                acl.add(new ACE(username, permission, false));
            }
        }
        this.cache.clear();
    }

    @Override
    public void setRules(UserEntry[] userEntries) {
        this.setRules("local", userEntries);
    }

    @Override
    public void setRules(UserEntry[] userEntries, boolean overwrite) {
        this.setRules("local", userEntries, overwrite);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.cache = new HashMap<String, Access>();
    }

    @Override
    public String[] listUsernamesForAnyPermission(Set<String> perms) {
        ArrayList<String> usernames = new ArrayList<String>();
        ACL merged = this.getMergedACLs("merged");
        for (ACE ace : merged.getACEs()) {
            String username;
            if (!perms.contains(ace.getPermission()) || !ace.isGranted() || usernames.contains(username = ace.getUsername())) continue;
            usernames.add(username);
        }
        return usernames.toArray(new String[usernames.size()]);
    }

    @Override
    public ACPImpl clone() {
        ACPImpl copy = new ACPImpl();
        for (ACL acl : this.acls) {
            copy.acls.add((ACL)acl.clone());
        }
        return copy;
    }

    @Override
    public boolean blockInheritance(String aclName, String username) {
        if (aclName == null) {
            throw new NullPointerException("'aclName' cannot be null");
        }
        if (username == null) {
            throw new NullPointerException("'username' cannot be null");
        }
        ACL acl = this.getOrCreateACL(aclName);
        boolean aclChanged = acl.blockInheritance(username);
        if (aclChanged) {
            this.addACL(acl);
        }
        return aclChanged;
    }

    @Override
    public boolean unblockInheritance(String aclName) {
        if (aclName == null) {
            throw new NullPointerException("'aclName' cannot be null");
        }
        ACL acl = this.getOrCreateACL(aclName);
        boolean aclChanged = acl.unblockInheritance();
        if (aclChanged) {
            this.addACL(acl);
        }
        return aclChanged;
    }

    @Override
    public boolean addACE(String aclName, ACE ace) {
        if (aclName == null) {
            throw new NullPointerException("'aclName' cannot be null");
        }
        ACL acl = this.getOrCreateACL(aclName);
        boolean aclChanged = acl.add(ace);
        if (aclChanged) {
            this.addACL(acl);
        }
        return aclChanged;
    }

    @Override
    public boolean replaceACE(String aclName, ACE oldACE, ACE newACE) {
        if (aclName == null) {
            throw new NullPointerException("'aclName' cannot be null");
        }
        ACL acl = this.getOrCreateACL(aclName);
        boolean aclChanged = acl.replace(oldACE, newACE);
        if (aclChanged) {
            this.addACL(acl);
        }
        return aclChanged;
    }

    @Override
    public boolean removeACE(String aclName, ACE ace) {
        if (aclName == null) {
            throw new NullPointerException("'aclName' cannot be null");
        }
        ACL acl = this.getOrCreateACL(aclName);
        boolean aclChanged = acl.remove(ace);
        if (aclChanged) {
            this.addACL(acl);
        }
        return aclChanged;
    }

    @Override
    public boolean removeACEsByUsername(String aclName, String username) {
        if (aclName == null) {
            throw new NullPointerException("'aclName' cannot be null");
        }
        ACL acl = this.getOrCreateACL(aclName);
        boolean aclChanged = acl.removeByUsername(username);
        if (aclChanged) {
            this.addACL(acl);
        }
        return aclChanged;
    }

    @Override
    public boolean removeACEsByUsername(String username) {
        boolean changed = false;
        for (ACL acl : this.acls) {
            boolean aclChanged = acl.removeByUsername(username);
            if (!aclChanged) continue;
            this.addACL(acl);
            changed = true;
        }
        return changed;
    }
}

