/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.BlobProviderDescriptor;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.binary.BinaryBlobProvider;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class BlobManagerComponent
extends DefaultComponent
implements BlobManager {
    private static final Log log = LogFactory.getLog(BlobManagerComponent.class);
    protected static final String XP = "configuration";
    protected BlobProviderDescriptorRegistry blobProviderDescriptorsRegistry = new BlobProviderDescriptorRegistry();
    protected Map<String, BlobProvider> blobProviders = new HashMap<String, BlobProvider>();

    public void deactivate(ComponentContext context) {
        this.blobProviderDescriptorsRegistry.clear();
        for (BlobProvider blobProvider : this.blobProviders.values()) {
            blobProvider.close();
        }
        this.blobProviders.clear();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP.equals(extensionPoint)) {
            if (!(contribution instanceof BlobProviderDescriptor)) {
                throw new NuxeoException("Invalid descriptor: " + contribution.getClass());
            }
        } else {
            throw new NuxeoException("Invalid extension point: " + extensionPoint);
        }
        this.registerBlobProvider((BlobProviderDescriptor)contribution);
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP.equals(extensionPoint) && contribution instanceof BlobProviderDescriptor) {
            this.unregisterBlobProvider((BlobProviderDescriptor)contribution);
        }
    }

    public void registerBlobProvider(BlobProviderDescriptor descr) {
        this.closeOldBlobProvider(descr.name);
        this.blobProviderDescriptorsRegistry.addContribution(descr);
        this.getBlobProvider(descr.name);
    }

    public void unregisterBlobProvider(BlobProviderDescriptor descr) {
        this.closeOldBlobProvider(descr.name);
        this.blobProviderDescriptorsRegistry.removeContribution(descr);
    }

    protected synchronized void closeOldBlobProvider(String id) {
        BlobProvider blobProvider = this.blobProviders.remove(id);
        if (blobProvider != null) {
            blobProvider.close();
        }
    }

    @Override
    public synchronized BlobProvider getBlobProvider(String providerId) {
        BlobProvider blobProvider = this.blobProviders.get(providerId);
        if (blobProvider == null) {
            Map<String, String> properties;
            block8: {
                BlobProviderDescriptor descr = this.blobProviderDescriptorsRegistry.getBlobProviderDescriptor(providerId);
                if (descr == null) {
                    return null;
                }
                Class<?> klass = descr.klass;
                properties = descr.properties;
                try {
                    if (BlobProvider.class.isAssignableFrom(klass)) {
                        Class<?> blobProviderClass = klass;
                        blobProvider = (BlobProvider)blobProviderClass.newInstance();
                        break block8;
                    }
                    if (BinaryManager.class.isAssignableFrom(klass)) {
                        Class<?> binaryManagerClass = klass;
                        BinaryManager binaryManager = (BinaryManager)binaryManagerClass.newInstance();
                        blobProvider = new BinaryBlobProvider(binaryManager);
                        break block8;
                    }
                    throw new RuntimeException("Unknown class for blob provider: " + klass);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                blobProvider.initialize(providerId, properties);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.blobProviders.put(providerId, blobProvider);
        }
        return blobProvider;
    }

    @Override
    public BlobProvider getBlobProvider(Blob blob) {
        if (!(blob instanceof ManagedBlob)) {
            return null;
        }
        ManagedBlob managedBlob = (ManagedBlob)blob;
        return this.getBlobProvider(managedBlob.getProviderId());
    }

    @Override
    public InputStream getStream(Blob blob) throws IOException {
        BlobProvider blobProvider = this.getBlobProvider(blob);
        if (blobProvider == null) {
            return null;
        }
        try {
            return blobProvider.getStream((ManagedBlob)blob);
        }
        catch (IOException e) {
            log.error((Object)("Failed to access file: " + ((ManagedBlob)blob).getKey()), (Throwable)e);
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    @Override
    public InputStream getThumbnail(Blob blob) throws IOException {
        BlobProvider blobProvider = this.getBlobProvider(blob);
        if (blobProvider == null) {
            return null;
        }
        return blobProvider.getThumbnail((ManagedBlob)blob);
    }

    @Override
    public URI getURI(Blob blob, BlobManager.UsageHint hint, HttpServletRequest servletRequest) throws IOException {
        BlobProvider blobProvider = this.getBlobProvider(blob);
        if (blobProvider == null) {
            return null;
        }
        return blobProvider.getURI((ManagedBlob)blob, hint, servletRequest);
    }

    @Override
    public Map<String, URI> getAvailableConversions(Blob blob, BlobManager.UsageHint hint) throws IOException {
        BlobProvider blobProvider = this.getBlobProvider(blob);
        if (blobProvider == null) {
            return Collections.emptyMap();
        }
        return blobProvider.getAvailableConversions((ManagedBlob)blob, hint);
    }

    @Override
    public Map<String, BlobProvider> getBlobProviders() {
        return this.blobProviders;
    }

    protected static class BlobProviderDescriptorRegistry
    extends SimpleContributionRegistry<BlobProviderDescriptor> {
        protected BlobProviderDescriptorRegistry() {
        }

        public String getContributionId(BlobProviderDescriptor contrib) {
            return contrib.name;
        }

        public BlobProviderDescriptor clone(BlobProviderDescriptor orig) {
            return new BlobProviderDescriptor(orig);
        }

        public void merge(BlobProviderDescriptor src, BlobProviderDescriptor dst) {
            dst.merge(src);
        }

        public boolean isSupportingMerge() {
            return true;
        }

        public void clear() {
            this.currentContribs.clear();
        }

        public BlobProviderDescriptor getBlobProviderDescriptor(String id) {
            return (BlobProviderDescriptor)this.getCurrentContribution(id);
        }
    }
}

