/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.jdbc.ClusterNodeHandler;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCConnection;

public class JDBCConnectionPropagator {
    public final List<JDBCConnection> connections = new ArrayList<JDBCConnection>();
    public ClusterNodeHandler clusterNodeHandler;

    public synchronized void addConnection(JDBCConnection connection) {
        this.connections.add(connection);
    }

    public void setClusterNodeHandler(ClusterNodeHandler clusterNodeHandler) {
        this.clusterNodeHandler = clusterNodeHandler;
    }

    public synchronized void removeConnection(JDBCConnection connection) {
        this.connections.remove(connection);
    }

    public synchronized void connectionWasReset(JDBCConnection connection) throws StorageException {
        if (this.clusterNodeHandler != null && this.clusterNodeHandler.getConnection() == connection) {
            this.clusterNodeHandler.connectionWasReset();
        }
        for (JDBCConnection c : this.connections) {
            if (c == connection) continue;
            c.connectionWasReset();
        }
    }
}

