/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.seam.deployment.AbstractClassDeploymentHandler;
import org.jboss.seam.deployment.ClassDeploymentMetadata;
import org.jboss.seam.deployment.ClassDescriptor;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

public class AnnotationDeploymentHandler
extends AbstractClassDeploymentHandler {
    public static final String NAME = "org.jboss.seam.deployment.AnnotationDeploymentHandler";
    public static final String ANNOTATIONS_KEY = "org.jboss.seam.deployment.annotationTypes";
    private static final LogProvider log = Logging.getLogProvider(AnnotationDeploymentHandler.class);
    private ClassDeploymentMetadata metadata;
    private Map<String, Set<Class<?>>> classes;
    private Set<Class<? extends Annotation>> annotations = new HashSet<Class<? extends Annotation>>();

    public AnnotationDeploymentHandler(List<String> annotationTypes, ClassLoader classLoader) {
        for (String classname : annotationTypes) {
            try {
                this.annotations.add(classLoader.loadClass(classname));
            }
            catch (ClassNotFoundException cnfe) {
                log.warn("could not load annotation class: " + classname, cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                log.warn("could not load annotation class (missing dependency): " + classname, ncdfe);
            }
            catch (ClassCastException cce) {
                log.warn("could not load annotation class (not an annotation): " + classname, cce);
            }
        }
        this.metadata = new AnnotationDeploymentHandlerMetadata(this.annotations);
    }

    public Map<String, Set<Class<?>>> getClassMap() {
        return Collections.unmodifiableMap(this.classes);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ClassDeploymentMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void postProcess(ClassLoader classLoader) {
        this.classes = new HashMap();
        for (Class<? extends Annotation> annotationType : this.annotations) {
            this.classes.put(annotationType.getName(), new HashSet());
        }
        for (ClassDescriptor classDescriptor : this.getClasses()) {
            for (Annotation annotation : classDescriptor.getClazz().getAnnotations()) {
                if (!this.classes.containsKey(annotation.annotationType().getName())) continue;
                this.classes.get(annotation.annotationType().getName()).add(classDescriptor.getClazz());
            }
        }
    }

    private class AnnotationDeploymentHandlerMetadata
    implements ClassDeploymentMetadata {
        private Set<Class<? extends Annotation>> annotations;

        public AnnotationDeploymentHandlerMetadata(Set<Class<? extends Annotation>> annotations) {
            this.annotations = annotations;
        }

        @Override
        public Set<Class<? extends Annotation>> getClassAnnotatedWith() {
            return this.annotations;
        }

        @Override
        public String getFileNameSuffix() {
            return null;
        }
    }
}

