/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.SACParserCSS3;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.MessageFormat;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.AbstractCacheableResource;
import org.richfaces.resource.StateHolderResource;
import org.richfaces.resource.css.CSSVisitorImpl;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.dom.css.CSSStyleSheet;

public class CompiledCSSResource
extends AbstractCacheableResource
implements StateHolderResource {
    private static final Logger LOGGER = RichfacesLogger.RESOURCE.getLogger();
    private static final String NULL_STYLESHEET = "Parsed stylesheet for ''{0}'':''{1}'' resource is null.";
    private Resource sourceResource;

    public CompiledCSSResource(Resource sourceResource) {
        assert (sourceResource != null);
        this.sourceResource = sourceResource;
    }

    public String getLibraryName() {
        return this.sourceResource.getLibraryName();
    }

    public void setLibraryName(String libraryName) {
        this.sourceResource.setLibraryName(libraryName);
    }

    public String getResourceName() {
        return this.sourceResource.getResourceName();
    }

    public void setResourceName(String resourceName) {
        this.sourceResource.setResourceName(resourceName);
    }

    public InputStream getResourceInputStream() throws IOException {
        return this.sourceResource.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        FacesContext ctx = FacesContext.getCurrentInstance();
        InputStream stream = null;
        CSSStyleSheet styleSheet = null;
        try {
            stream = this.getResourceInputStream();
            if (null == stream) {
                InputStream inputStream = null;
                return inputStream;
            }
            InputSource source = new InputSource((Reader)new InputStreamReader(stream));
            CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS3());
            ErrorHandlerImpl errorHandler = new ErrorHandlerImpl(this, ctx.isProjectStage(ProjectStage.Production));
            parser.setErrorHandler((ErrorHandler)errorHandler);
            styleSheet = parser.parseStyleSheet(source, null, null);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOGGER.warn(e.getMessage(), e);
                }
            }
        }
        if (styleSheet != null) {
            String encoding = ctx.getExternalContext().getResponseCharacterEncoding();
            CSSVisitorImpl cssVisitor = new CSSVisitorImpl(ctx);
            cssVisitor.setEncoding(encoding != null ? encoding : "UTF-8");
            cssVisitor.visitStyleSheet(styleSheet);
            String cssText = cssVisitor.getCSSText();
            return new ByteArrayInputStream(cssText.getBytes(cssVisitor.getEncoding()));
        }
        if (!ctx.isProjectStage(ProjectStage.Production)) {
            LOGGER.info(MessageFormat.format(NULL_STYLESHEET, this.getLibraryName(), this.getResourceName()));
        }
        return null;
    }

    public String getContentType() {
        return "text/css";
    }

    private static int getSkinHashCode(FacesContext context) {
        Skin skin = SkinFactory.getInstance(context).getSkin(context);
        return skin.hashCode(context);
    }

    @Override
    public boolean userAgentNeedsUpdate(FacesContext context) {
        if (context.isProjectStage(ProjectStage.Development)) {
            return true;
        }
        return super.userAgentNeedsUpdate(context);
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public void readState(FacesContext context, DataInput dataInput) throws IOException {
    }

    @Override
    public void writeState(FacesContext context, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(CompiledCSSResource.getSkinHashCode(context));
    }

    private static final class ErrorHandlerImpl
    implements ErrorHandler {
        private boolean productionStage;
        private Resource resource;
        private String resourceLocator;

        public ErrorHandlerImpl(Resource resource, boolean productionStage) {
            this.resource = resource;
            this.productionStage = productionStage;
        }

        private String getResourceLocator() {
            if (this.resourceLocator == null) {
                String libraryName = this.resource.getLibraryName();
                String resourceName = this.resource.getResourceName();
                this.resourceLocator = libraryName != null && libraryName.length() != 0 ? libraryName + '/' + resourceName : resourceName;
            }
            return this.resourceLocator;
        }

        private void logException(CSSParseException e) {
            String formattedMessage = MessageFormat.format("Problem parsing ''{0}'' resource: {1}", this.getResourceLocator(), e.getMessage());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(formattedMessage, (Throwable)e);
            } else {
                LOGGER.warn(formattedMessage);
            }
        }

        public void error(CSSParseException e) throws CSSException {
            this.logException(e);
        }

        public void fatalError(CSSParseException e) throws CSSException {
            this.logException(e);
        }

        public void warning(CSSParseException e) throws CSSException {
            this.logException(e);
        }
    }
}

