/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.InternalClusterInfoService;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.action.index.NodeIndexDeletedAction;
import org.elasticsearch.cluster.action.index.NodeMappingRefreshAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.MetaDataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetaDataDeleteIndexService;
import org.elasticsearch.cluster.metadata.MetaDataIndexAliasesService;
import org.elasticsearch.cluster.metadata.MetaDataIndexStateService;
import org.elasticsearch.cluster.metadata.MetaDataIndexTemplateService;
import org.elasticsearch.cluster.metadata.MetaDataMappingService;
import org.elasticsearch.cluster.metadata.MetaDataService;
import org.elasticsearch.cluster.metadata.MetaDataUpdateSettingsService;
import org.elasticsearch.cluster.node.DiscoveryNodeService;
import org.elasticsearch.cluster.routing.RoutingService;
import org.elasticsearch.cluster.routing.allocation.AllocationModule;
import org.elasticsearch.cluster.routing.operation.OperationRoutingModule;
import org.elasticsearch.cluster.service.InternalClusterService;
import org.elasticsearch.cluster.settings.ClusterDynamicSettingsModule;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.SpawnModules;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.settings.IndexDynamicSettingsModule;

public class ClusterModule
extends AbstractModule
implements SpawnModules {
    private final Settings settings;

    public ClusterModule(Settings settings) {
        this.settings = settings;
    }

    @Override
    public Iterable<? extends Module> spawnModules() {
        return ImmutableList.of(new AllocationModule(this.settings), new OperationRoutingModule(this.settings), new ClusterDynamicSettingsModule(), new IndexDynamicSettingsModule());
    }

    @Override
    protected void configure() {
        this.bind(DiscoveryNodeService.class).asEagerSingleton();
        this.bind(ClusterService.class).to(InternalClusterService.class).asEagerSingleton();
        this.bind(MetaDataService.class).asEagerSingleton();
        this.bind(MetaDataCreateIndexService.class).asEagerSingleton();
        this.bind(MetaDataDeleteIndexService.class).asEagerSingleton();
        this.bind(MetaDataIndexStateService.class).asEagerSingleton();
        this.bind(MetaDataMappingService.class).asEagerSingleton();
        this.bind(MetaDataIndexAliasesService.class).asEagerSingleton();
        this.bind(MetaDataUpdateSettingsService.class).asEagerSingleton();
        this.bind(MetaDataIndexTemplateService.class).asEagerSingleton();
        this.bind(RoutingService.class).asEagerSingleton();
        this.bind(ShardStateAction.class).asEagerSingleton();
        this.bind(NodeIndexDeletedAction.class).asEagerSingleton();
        this.bind(NodeMappingRefreshAction.class).asEagerSingleton();
        this.bind(MappingUpdatedAction.class).asEagerSingleton();
        this.bind(ClusterInfoService.class).to(InternalClusterInfoService.class).asEagerSingleton();
    }
}

