/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.yaml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.jackson.core.JsonGenerator;
import org.elasticsearch.common.jackson.dataformat.yaml.YAMLParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContentGenerator;
import org.elasticsearch.common.xcontent.yaml.YamlXContent;

public class YamlXContentGenerator
extends JsonXContentGenerator {
    public YamlXContentGenerator(JsonGenerator generator) {
        super(generator);
    }

    @Override
    public XContentType contentType() {
        return XContentType.YAML;
    }

    @Override
    public void usePrintLineFeedAtEnd() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRawField(String fieldName, InputStream content, OutputStream bos) throws IOException {
        this.writeFieldName(fieldName);
        YAMLParser parser = YamlXContent.yamlFactory.createParser(content);
        try {
            parser.nextToken();
            this.generator.copyCurrentStructure(parser);
        }
        finally {
            parser.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRawField(String fieldName, byte[] content, OutputStream bos) throws IOException {
        this.writeFieldName(fieldName);
        YAMLParser parser = YamlXContent.yamlFactory.createParser(content);
        try {
            parser.nextToken();
            this.generator.copyCurrentStructure(parser);
        }
        finally {
            parser.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeObjectRaw(String fieldName, BytesReference content, OutputStream bos) throws IOException {
        this.writeFieldName(fieldName);
        YAMLParser parser = content.hasArray() ? YamlXContent.yamlFactory.createParser(content.array(), content.arrayOffset(), content.length()) : YamlXContent.yamlFactory.createParser(content.streamInput());
        try {
            parser.nextToken();
            this.generator.copyCurrentStructure(parser);
        }
        finally {
            parser.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRawField(String fieldName, byte[] content, int offset, int length, OutputStream bos) throws IOException {
        this.writeFieldName(fieldName);
        YAMLParser parser = YamlXContent.yamlFactory.createParser(content, offset, length);
        try {
            parser.nextToken();
            this.generator.copyCurrentStructure(parser);
        }
        finally {
            parser.close();
        }
    }
}

