/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.io.Reader;
import org.elasticsearch.common.joda.time.format.DateTimeFormatter;
import org.elasticsearch.index.analysis.NumericAnalyzer;
import org.elasticsearch.index.analysis.NumericDateTokenizer;

public class NumericDateAnalyzer
extends NumericAnalyzer<NumericDateTokenizer> {
    private final int precisionStep;
    private final DateTimeFormatter dateTimeFormatter;

    public NumericDateAnalyzer(DateTimeFormatter dateTimeFormatter) {
        this(4, dateTimeFormatter);
    }

    public NumericDateAnalyzer(int precisionStep, DateTimeFormatter dateTimeFormatter) {
        this.precisionStep = precisionStep;
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    protected NumericDateTokenizer createNumericTokenizer(Reader reader, char[] buffer) throws IOException {
        return new NumericDateTokenizer(reader, this.precisionStep, buffer, this.dateTimeFormatter);
    }
}

