/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.postingsformat;

import org.apache.lucene.codecs.PostingsFormat;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;

public class PreBuiltPostingsFormatProvider
implements PostingsFormatProvider {
    private final String name;
    private final PostingsFormat postingsFormat;

    public PreBuiltPostingsFormatProvider(PostingsFormat postingsFormat) {
        this(postingsFormat.getName(), postingsFormat);
    }

    public PreBuiltPostingsFormatProvider(String name, PostingsFormat postingsFormat) {
        if (postingsFormat == null) {
            throw new IllegalArgumentException("PostingsFormat must not be null");
        }
        this.name = name;
        this.postingsFormat = postingsFormat;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public PostingsFormat get() {
        return this.postingsFormat;
    }

    public static final class Factory
    implements PostingsFormatProvider.Factory {
        private final PreBuiltPostingsFormatProvider provider;

        public Factory(PostingsFormat postingsFormat) {
            this(postingsFormat.getName(), postingsFormat);
        }

        public Factory(String name, PostingsFormat postingsFormat) {
            this.provider = new PreBuiltPostingsFormatProvider(name, postingsFormat);
        }

        public PostingsFormatProvider get() {
            return this.provider;
        }

        @Override
        public PostingsFormatProvider create(String name, Settings settings) {
            return this.provider;
        }

        public String name() {
            return this.provider.name();
        }
    }
}

