/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.LongValues;

public class MurmurHash3Values {
    public static LongValues wrap(DoubleValues values) {
        return new Double(values);
    }

    public static LongValues wrap(LongValues values) {
        return new Long(values);
    }

    public static LongValues wrap(BytesValues values) {
        return new Bytes(values);
    }

    private static class Bytes
    extends LongValues {
        private final MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();
        private final BytesValues values;

        public Bytes(BytesValues values) {
            super(values.isMultiValued());
            this.values = values;
        }

        @Override
        public int setDocument(int docId) {
            return this.values.setDocument(docId);
        }

        @Override
        public long nextValue() {
            BytesRef next = this.values.nextValue();
            MurmurHash3.hash128(next.bytes, next.offset, next.length, 0L, this.hash);
            return this.hash.h1;
        }

        @Override
        public AtomicFieldData.Order getOrder() {
            return AtomicFieldData.Order.NONE;
        }
    }

    private static class Double
    extends LongValues {
        private final DoubleValues values;

        public Double(DoubleValues values) {
            super(values.isMultiValued());
            this.values = values;
        }

        @Override
        public int setDocument(int docId) {
            return this.values.setDocument(docId);
        }

        @Override
        public long nextValue() {
            return org.elasticsearch.common.hppc.hash.MurmurHash3.hash(java.lang.Double.doubleToLongBits(this.values.nextValue()));
        }

        @Override
        public AtomicFieldData.Order getOrder() {
            return AtomicFieldData.Order.NONE;
        }
    }

    private static class Long
    extends LongValues {
        private final LongValues values;

        public Long(LongValues values) {
            super(values.isMultiValued());
            this.values = values;
        }

        @Override
        public int setDocument(int docId) {
            return this.values.setDocument(docId);
        }

        @Override
        public long nextValue() {
            return org.elasticsearch.common.hppc.hash.MurmurHash3.hash(this.values.nextValue());
        }

        @Override
        public AtomicFieldData.Order getOrder() {
            return AtomicFieldData.Order.NONE;
        }
    }
}

