/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NumericFloatAnalyzer;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.FloatFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.search.NumericRangeFieldDataFilter;

public class BoostFieldMapper
extends NumberFieldMapper<Float>
implements InternalMapper,
RootMapper {
    public static final String CONTENT_TYPE = "_boost";
    public static final String NAME = "_boost";
    private final Float nullValue;

    public BoostFieldMapper() {
        this("_boost", "_boost");
    }

    protected BoostFieldMapper(String name, String indexName) {
        this(name, indexName, 4, 1.0f, new FieldType(Defaults.FIELD_TYPE), null, Defaults.NULL_VALUE, null, null, null, ImmutableSettings.EMPTY);
    }

    protected BoostFieldMapper(String name, String indexName, int precisionStep, float boost, FieldType fieldType, Boolean docValues, Float nullValue, PostingsFormatProvider postingsProvider, DocValuesFormatProvider docValuesProvider, @Nullable Settings fieldDataSettings, Settings indexSettings) {
        super(new FieldMapper.Names(name, indexName, indexName, name), precisionStep, boost, fieldType, docValues, Defaults.IGNORE_MALFORMED, Defaults.COERCE, NumericFloatAnalyzer.buildNamedAnalyzer(precisionStep), NumericFloatAnalyzer.buildNamedAnalyzer(Integer.MAX_VALUE), postingsProvider, docValuesProvider, null, null, fieldDataSettings, indexSettings, AbstractFieldMapper.MultiFields.empty(), null);
        this.nullValue = nullValue;
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType("float");
    }

    @Override
    public boolean hasDocValues() {
        return false;
    }

    @Override
    protected int maxPrecisionStep() {
        return 32;
    }

    @Override
    public Float value(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof BytesRef) {
            return Float.valueOf(Numbers.bytesToFloat((BytesRef)value));
        }
        return Float.valueOf(Float.parseFloat(value.toString()));
    }

    @Override
    public BytesRef indexedValueForSearch(Object value) {
        int intValue = NumericUtils.floatToSortableInt((float)this.parseValue(value));
        BytesRef bytesRef = new BytesRef();
        NumericUtils.intToPrefixCoded((int)intValue, (int)this.precisionStep(), (BytesRef)bytesRef);
        return bytesRef;
    }

    private float parseValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof BytesRef) {
            return Float.parseFloat(((BytesRef)value).utf8ToString());
        }
        return Float.parseFloat(value.toString());
    }

    @Override
    public Query fuzzyQuery(String value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions) {
        float iValue = Float.parseFloat(value);
        float iSim = fuzziness.asFloat();
        return NumericRangeQuery.newFloatRange((String)this.names.indexName(), (int)this.precisionStep, (Float)Float.valueOf(iValue - iSim), (Float)Float.valueOf(iValue + iSim), (boolean)true, (boolean)true);
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeQuery.newFloatRange((String)this.names.indexName(), (int)this.precisionStep, (Float)(lowerTerm == null ? null : Float.valueOf(this.parseValue(lowerTerm))), (Float)(upperTerm == null ? null : Float.valueOf(this.parseValue(upperTerm))), (boolean)includeLower, (boolean)includeUpper);
    }

    @Override
    public Filter rangeFilter(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeFilter.newFloatRange((String)this.names.indexName(), (int)this.precisionStep, (Float)(lowerTerm == null ? null : Float.valueOf(this.parseValue(lowerTerm))), (Float)(upperTerm == null ? null : Float.valueOf(this.parseValue(upperTerm))), (boolean)includeLower, (boolean)includeUpper);
    }

    @Override
    public Filter rangeFilter(IndexFieldDataService fieldData, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeFieldDataFilter.newFloatRange((IndexNumericFieldData)fieldData.getForField(this), lowerTerm == null ? null : Float.valueOf(this.parseValue(lowerTerm)), upperTerm == null ? null : Float.valueOf(this.parseValue(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter nullValueFilter() {
        if (this.nullValue == null) {
            return null;
        }
        return NumericRangeFilter.newFloatRange((String)this.names.indexName(), (int)this.precisionStep, (Float)this.nullValue, (Float)this.nullValue, (boolean)true, (boolean)true);
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    public boolean includeInObject() {
        return true;
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        float value = this.parseFloatValue(context);
        if (!Float.isNaN(value)) {
            context.docBoost(value);
        }
        super.parse(context);
    }

    @Override
    protected void innerParseCreateField(ParseContext context, List<Field> fields) throws IOException {
        float value = this.parseFloatValue(context);
        if (Float.isNaN(value)) {
            return;
        }
        context.docBoost(value);
        fields.add(new FloatFieldMapper.CustomFloatNumericField((NumberFieldMapper)this, value, this.fieldType));
    }

    private float parseFloatValue(ParseContext context) throws IOException {
        float value;
        if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
            if (this.nullValue == null) {
                return Float.NaN;
            }
            value = this.nullValue.floatValue();
        } else {
            value = context.parser().floatValue((Boolean)this.coerce.value());
        }
        return value;
    }

    @Override
    protected String contentType() {
        return "_boost";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && this.name().equals("_boost") && this.nullValue == null && this.fieldType.indexed() == Defaults.FIELD_TYPE.indexed() && this.fieldType.stored() == Defaults.FIELD_TYPE.stored() && this.customFieldDataSettings == null) {
            return builder;
        }
        builder.startObject(this.contentType());
        if (includeDefaults || !this.name().equals("_boost")) {
            builder.field("name", this.name());
        }
        if (includeDefaults || this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        if (includeDefaults || this.fieldType.indexed() != Defaults.FIELD_TYPE.indexed()) {
            builder.field("index", this.fieldType.indexed());
        }
        if (includeDefaults || this.fieldType.stored() != Defaults.FIELD_TYPE.stored()) {
            builder.field("store", this.fieldType.stored());
        }
        if (this.customFieldDataSettings != null) {
            builder.field("fielddata", this.customFieldDataSettings.getAsMap());
        } else if (includeDefaults) {
            builder.field("fielddata", this.fieldDataType.getSettings().getAsMap());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String fieldName, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            String name = node.get("name") == null ? "_boost" : node.get("name").toString();
            Builder builder = MapperBuilders.boost(name);
            TypeParsers.parseNumberField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (!propName.equals("null_value")) continue;
                builder.nullValue(XContentMapValues.nodeFloatValue(propNode));
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, BoostFieldMapper> {
        protected Float nullValue = Defaults.NULL_VALUE;

        public Builder(String name) {
            super(name, new FieldType(Defaults.FIELD_TYPE));
            this.builder = this;
        }

        public Builder nullValue(float nullValue) {
            this.nullValue = Float.valueOf(nullValue);
            return this;
        }

        @Override
        public BoostFieldMapper build(Mapper.BuilderContext context) {
            return new BoostFieldMapper(this.name, this.buildIndexName(context), this.precisionStep, this.boost, this.fieldType, this.docValues, this.nullValue, this.postingsProvider, this.docValuesProvider, this.fieldDataSettings, context.indexSettings());
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final String NAME = "_boost";
        public static final Float NULL_VALUE = null;
        public static final FieldType FIELD_TYPE = new FieldType(NumberFieldMapper.Defaults.FIELD_TYPE);

        static {
            FIELD_TYPE.setIndexed(false);
            FIELD_TYPE.setStored(false);
        }
    }
}

