/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermFilter;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.AndFilter;
import org.elasticsearch.common.lucene.search.ApplyAcceptedDocsFilter;
import org.elasticsearch.common.lucene.search.NoopCollector;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.common.util.FloatArray;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.ParentChildAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.search.child.ParentIdsFilter;
import org.elasticsearch.index.search.child.ScoreType;
import org.elasticsearch.search.internal.SearchContext;

public class ChildrenQuery
extends Query {
    private final ParentChildIndexFieldData parentChildIndexFieldData;
    private final String parentType;
    private final String childType;
    private final Filter parentFilter;
    private final ScoreType scoreType;
    private Query originalChildQuery;
    private final int shortCircuitParentDocSet;
    private final Filter nonNestedDocsFilter;
    private Query rewrittenChildQuery;
    private IndexReader rewriteIndexReader;

    public ChildrenQuery(ParentChildIndexFieldData parentChildIndexFieldData, String parentType, String childType, Filter parentFilter, Query childQuery, ScoreType scoreType, int shortCircuitParentDocSet, Filter nonNestedDocsFilter) {
        this.parentChildIndexFieldData = parentChildIndexFieldData;
        this.parentType = parentType;
        this.childType = childType;
        this.parentFilter = parentFilter;
        this.originalChildQuery = childQuery;
        this.scoreType = scoreType;
        this.shortCircuitParentDocSet = shortCircuitParentDocSet;
        this.nonNestedDocsFilter = nonNestedDocsFilter;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        ChildrenQuery that = (ChildrenQuery)((Object)obj);
        if (!this.originalChildQuery.equals((Object)that.originalChildQuery)) {
            return false;
        }
        if (!this.childType.equals(that.childType)) {
            return false;
        }
        return this.getBoost() == that.getBoost();
    }

    public int hashCode() {
        int result = this.originalChildQuery.hashCode();
        result = 31 * result + this.childType.hashCode();
        result = 31 * result + Float.floatToIntBits(this.getBoost());
        return result;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("ChildrenQuery[").append(this.childType).append("/").append(this.parentType).append("](").append(this.originalChildQuery.toString(field)).append(')').append(ToStringUtils.boost((float)this.getBoost()));
        return sb.toString();
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.rewrittenChildQuery == null) {
            this.rewriteIndexReader = reader;
            this.rewrittenChildQuery = this.originalChildQuery.rewrite(reader);
        }
        return this;
    }

    public Query clone() {
        ChildrenQuery q = (ChildrenQuery)super.clone();
        q.originalChildQuery = this.originalChildQuery.clone();
        if (q.rewrittenChildQuery != null) {
            q.rewrittenChildQuery = this.rewrittenChildQuery.clone();
        }
        return q;
    }

    public void extractTerms(Set<Term> terms) {
        this.rewrittenChildQuery.extractTerms(terms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Weight createWeight(IndexSearcher searcher) throws IOException {
        Filter parentFilter;
        IntArray occurrences;
        FloatArray scores;
        BytesRefHash parentIds;
        Query childQuery;
        SearchContext searchContext = SearchContext.current();
        if (this.rewrittenChildQuery == null) {
            childQuery = this.rewrittenChildQuery = searcher.rewrite(this.originalChildQuery);
        } else {
            assert (this.rewriteIndexReader == searcher.getIndexReader()) : "not equal, rewriteIndexReader=" + this.rewriteIndexReader + " searcher.getIndexReader()=" + searcher.getIndexReader();
            childQuery = this.rewrittenChildQuery;
        }
        IndexSearcher indexSearcher = new IndexSearcher(searcher.getIndexReader());
        indexSearcher.setSimilarity(searcher.getSimilarity());
        switch (this.scoreType) {
            case MAX: {
                MaxCollector maxCollector = new MaxCollector(this.parentChildIndexFieldData, this.parentType, searchContext);
                try {
                    indexSearcher.search(childQuery, (Collector)maxCollector);
                    parentIds = maxCollector.parentIds;
                    scores = maxCollector.scores;
                    occurrences = null;
                }
                catch (Throwable throwable) {
                    Releasables.release(maxCollector.parentIdsIndex);
                    throw throwable;
                }
                Releasables.release(maxCollector.parentIdsIndex);
                break;
            }
            case SUM: {
                SumCollector sumCollector = new SumCollector(this.parentChildIndexFieldData, this.parentType, searchContext);
                try {
                    indexSearcher.search(childQuery, (Collector)sumCollector);
                    parentIds = sumCollector.parentIds;
                    scores = sumCollector.scores;
                    occurrences = null;
                }
                catch (Throwable throwable) {
                    Releasables.release(sumCollector.parentIdsIndex);
                    throw throwable;
                }
                Releasables.release(sumCollector.parentIdsIndex);
                break;
            }
            case AVG: {
                AvgCollector avgCollector = new AvgCollector(this.parentChildIndexFieldData, this.parentType, searchContext);
                try {
                    indexSearcher.search(childQuery, (Collector)avgCollector);
                    parentIds = avgCollector.parentIds;
                    scores = avgCollector.scores;
                    occurrences = avgCollector.occurrences;
                }
                catch (Throwable throwable) {
                    Releasables.release(avgCollector.parentIdsIndex);
                    throw throwable;
                }
                Releasables.release(avgCollector.parentIdsIndex);
                break;
            }
            default: {
                throw new RuntimeException("Are we missing a score type here? -- " + (Object)((Object)this.scoreType));
            }
        }
        int size = (int)parentIds.size();
        if (size == 0) {
            Releasables.release(parentIds, scores, occurrences);
            return Queries.newMatchNoDocsQuery().createWeight(searcher);
        }
        if (size == 1) {
            BytesRef id = parentIds.get(0L, new BytesRef());
            if (this.nonNestedDocsFilter != null) {
                List<Filter> filters = Arrays.asList(new TermFilter(new Term("_uid", Uid.createUidAsBytes(this.parentType, id))), this.nonNestedDocsFilter);
                parentFilter = new AndFilter(filters);
            } else {
                parentFilter = new TermFilter(new Term("_uid", Uid.createUidAsBytes(this.parentType, id)));
            }
        } else {
            parentFilter = size <= this.shortCircuitParentDocSet ? new ParentIdsFilter(this.parentType, this.nonNestedDocsFilter, parentIds) : new ApplyAcceptedDocsFilter(this.parentFilter);
        }
        ParentWeight parentWeight = new ParentWeight(this.rewrittenChildQuery.createWeight(searcher), parentFilter, size, parentIds, scores, occurrences);
        searchContext.addReleasable(parentWeight);
        return parentWeight;
    }

    private static final class AvgCollector
    extends ParentIdAndScoreCollector {
        private IntArray occurrences;

        AvgCollector(ParentChildIndexFieldData indexFieldData, String childType, SearchContext searchContext) {
            super(indexFieldData, childType, searchContext);
            this.occurrences = this.bigArrays.newIntArray(512L, false);
        }

        @Override
        public void collect(int doc) throws IOException {
            if (this.values != null) {
                int ord = (int)this.ordinals.getOrd(doc);
                long parentIdx = this.parentIdsIndex.get(ord);
                if (parentIdx < 0L) {
                    int hash;
                    BytesRef bytes = this.values.getValueByOrd(ord);
                    parentIdx = this.parentIds.add(bytes, hash = this.values.currentValueHash());
                    if (parentIdx < 0L) {
                        parentIdx = -parentIdx - 1L;
                        this.scores.increment(parentIdx, this.scorer.score());
                        this.occurrences.increment(parentIdx, 1);
                    } else {
                        this.scores = this.bigArrays.grow(this.scores, parentIdx + 1L);
                        this.scores.set(parentIdx, this.scorer.score());
                        this.occurrences = this.bigArrays.grow(this.occurrences, parentIdx + 1L);
                        this.occurrences.set(parentIdx, 1);
                    }
                    this.parentIdsIndex.set(ord, parentIdx);
                } else {
                    this.scores.increment(parentIdx, this.scorer.score());
                    this.occurrences.increment(parentIdx, 1);
                }
            }
        }
    }

    private static final class MaxCollector
    extends ParentIdAndScoreCollector {
        private MaxCollector(ParentChildIndexFieldData indexFieldData, String childType, SearchContext searchContext) {
            super(indexFieldData, childType, searchContext);
        }

        @Override
        protected void doScore(long index) throws IOException {
            float currentScore = this.scorer.score();
            if (currentScore > this.scores.get(index)) {
                this.scores.set(index, currentScore);
            }
        }
    }

    private static final class SumCollector
    extends ParentIdAndScoreCollector {
        private SumCollector(ParentChildIndexFieldData indexFieldData, String parentType, SearchContext searchContext) {
            super(indexFieldData, parentType, searchContext);
        }

        @Override
        protected void doScore(long index) throws IOException {
            this.scores.increment(index, this.scorer.score());
        }
    }

    private static abstract class ParentIdAndScoreCollector
    extends NoopCollector {
        final BytesRefHash parentIds;
        protected final String parentType;
        private final ParentChildIndexFieldData indexFieldData;
        protected final BigArrays bigArrays;
        protected FloatArray scores;
        protected BytesValues.WithOrdinals values;
        protected Ordinals.Docs ordinals;
        protected Scorer scorer;
        protected LongArray parentIdsIndex;

        private ParentIdAndScoreCollector(ParentChildIndexFieldData indexFieldData, String parentType, SearchContext searchContext) {
            this.parentType = parentType;
            this.indexFieldData = indexFieldData;
            this.bigArrays = searchContext.bigArrays();
            this.parentIds = new BytesRefHash(512L, this.bigArrays);
            this.scores = this.bigArrays.newFloatArray(512L, false);
        }

        @Override
        public void collect(int doc) throws IOException {
            if (this.values != null) {
                long ord = this.ordinals.getOrd(doc);
                long parentIdx = this.parentIdsIndex.get(ord);
                if (parentIdx < 0L) {
                    int hash;
                    BytesRef bytes = this.values.getValueByOrd(ord);
                    parentIdx = this.parentIds.add(bytes, hash = this.values.currentValueHash());
                    if (parentIdx < 0L) {
                        parentIdx = -parentIdx - 1L;
                        this.doScore(parentIdx);
                    } else {
                        this.scores = this.bigArrays.grow(this.scores, parentIdx + 1L);
                        this.scores.set(parentIdx, this.scorer.score());
                    }
                    this.parentIdsIndex.set(ord, parentIdx);
                } else {
                    this.doScore(parentIdx);
                }
            }
        }

        protected void doScore(long index) throws IOException {
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = ((ParentChildAtomicFieldData)this.indexFieldData.load(context)).getBytesValues(this.parentType);
            if (this.values != null) {
                this.ordinals = this.values.ordinals();
                long maxOrd = this.ordinals.getMaxOrd();
                if (this.parentIdsIndex == null) {
                    this.parentIdsIndex = this.bigArrays.newLongArray(BigArrays.overSize(maxOrd), false);
                } else if (this.parentIdsIndex.size() < maxOrd) {
                    this.parentIdsIndex = this.bigArrays.grow(this.parentIdsIndex, maxOrd);
                }
                this.parentIdsIndex.fill(0L, maxOrd, -1L);
            }
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }
    }

    private final class ParentWeight
    extends Weight
    implements Releasable {
        private final Weight childWeight;
        private final Filter parentFilter;
        private final BytesRefHash parentIds;
        private final FloatArray scores;
        private final IntArray occurrences;
        private int remaining;

        private ParentWeight(Weight childWeight, Filter parentFilter, int remaining, BytesRefHash parentIds, FloatArray scores, IntArray occurrences) {
            this.childWeight = childWeight;
            this.parentFilter = parentFilter;
            this.remaining = remaining;
            this.parentIds = parentIds;
            this.scores = scores;
            this.occurrences = occurrences;
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            return new Explanation(ChildrenQuery.this.getBoost(), "not implemented yet...");
        }

        public Query getQuery() {
            return ChildrenQuery.this;
        }

        public float getValueForNormalization() throws IOException {
            float sum = this.childWeight.getValueForNormalization();
            return sum *= ChildrenQuery.this.getBoost() * ChildrenQuery.this.getBoost();
        }

        public void normalize(float norm, float topLevelBoost) {
        }

        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            DocIdSet parentsSet = this.parentFilter.getDocIdSet(context, acceptDocs);
            if (DocIdSets.isEmpty(parentsSet) || this.remaining == 0) {
                return null;
            }
            BytesValues.WithOrdinals bytesValues = ((ParentChildAtomicFieldData)ChildrenQuery.this.parentChildIndexFieldData.load(context)).getBytesValues(ChildrenQuery.this.parentType);
            if (bytesValues == null) {
                return null;
            }
            DocIdSetIterator parentsIterator = BitsFilteredDocIdSet.wrap((DocIdSet)parentsSet, (Bits)context.reader().getLiveDocs()).iterator();
            switch (ChildrenQuery.this.scoreType) {
                case AVG: {
                    return new AvgParentScorer(this, bytesValues, this.parentIds, this.scores, this.occurrences, parentsIterator);
                }
            }
            return new ParentScorer(this, bytesValues, this.parentIds, this.scores, parentsIterator);
        }

        @Override
        public boolean release() throws ElasticsearchException {
            Releasables.release(this.parentIds, this.scores, this.occurrences);
            return true;
        }

        private final class AvgParentScorer
        extends ParentScorer {
            final IntArray occurrences;

            AvgParentScorer(Weight weight, BytesValues values, BytesRefHash parentIds, FloatArray scores, IntArray occurrences, DocIdSetIterator parentsIterator) {
                super(weight, values, parentIds, scores, parentsIterator);
                this.occurrences = occurrences;
            }

            @Override
            public int nextDoc() throws IOException {
                long index;
                if (ParentWeight.this.remaining == 0) {
                    this.currentDocId = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                do {
                    this.currentDocId = this.parentsIterator.nextDoc();
                    if (this.currentDocId == Integer.MAX_VALUE) {
                        return this.currentDocId;
                    }
                    this.bytesValues.setDocument(this.currentDocId);
                } while ((index = this.parentIds.find(this.bytesValues.nextValue(), this.bytesValues.currentValueHash())) == -1L);
                this.currentScore = this.scores.get(index);
                this.currentScore /= (float)this.occurrences.get(index);
                ParentWeight.this.remaining--;
                return this.currentDocId;
            }

            @Override
            public int advance(int target) throws IOException {
                if (ParentWeight.this.remaining == 0) {
                    this.currentDocId = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.currentDocId = this.parentsIterator.advance(target);
                if (this.currentDocId == Integer.MAX_VALUE) {
                    return this.currentDocId;
                }
                this.bytesValues.setDocument(this.currentDocId);
                long index = this.parentIds.find(this.bytesValues.nextValue(), this.bytesValues.currentValueHash());
                if (index != -1L) {
                    this.currentScore = this.scores.get(index);
                    this.currentScore /= (float)this.occurrences.get(index);
                    ParentWeight.this.remaining--;
                    return this.currentDocId;
                }
                return this.nextDoc();
            }
        }

        private class ParentScorer
        extends Scorer {
            final BytesRefHash parentIds;
            final FloatArray scores;
            final BytesValues bytesValues;
            final DocIdSetIterator parentsIterator;
            int currentDocId;
            float currentScore;

            ParentScorer(Weight weight, BytesValues bytesValues, BytesRefHash parentIds, FloatArray scores, DocIdSetIterator parentsIterator) {
                super(weight);
                this.currentDocId = -1;
                this.bytesValues = bytesValues;
                this.parentsIterator = parentsIterator;
                this.parentIds = parentIds;
                this.scores = scores;
            }

            public float score() throws IOException {
                return this.currentScore;
            }

            public int freq() throws IOException {
                return 1;
            }

            public int docID() {
                return this.currentDocId;
            }

            public int nextDoc() throws IOException {
                long index;
                if (ParentWeight.this.remaining == 0) {
                    this.currentDocId = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                do {
                    this.currentDocId = this.parentsIterator.nextDoc();
                    if (this.currentDocId == Integer.MAX_VALUE) {
                        return this.currentDocId;
                    }
                    this.bytesValues.setDocument(this.currentDocId);
                } while ((index = this.parentIds.find(this.bytesValues.nextValue(), this.bytesValues.currentValueHash())) == -1L);
                this.currentScore = this.scores.get(index);
                ParentWeight.this.remaining--;
                return this.currentDocId;
            }

            public int advance(int target) throws IOException {
                if (ParentWeight.this.remaining == 0) {
                    this.currentDocId = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.currentDocId = this.parentsIterator.advance(target);
                if (this.currentDocId == Integer.MAX_VALUE) {
                    return this.currentDocId;
                }
                this.bytesValues.setDocument(this.currentDocId);
                long index = this.parentIds.find(this.bytesValues.nextValue(), this.bytesValues.currentValueHash());
                if (index != -1L) {
                    this.currentScore = this.scores.get(index);
                    ParentWeight.this.remaining--;
                    return this.currentDocId;
                }
                return this.nextDoc();
            }

            public long cost() {
                return this.parentsIterator.cost();
            }
        }
    }
}

