/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.ApplyAcceptedDocsFilter;
import org.elasticsearch.common.lucene.search.NoopCollector;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.ParentChildAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.index.search.child.ConstantScorer;
import org.elasticsearch.search.internal.SearchContext;

public class ParentConstantScoreQuery
extends Query {
    private final ParentChildIndexFieldData parentChildIndexFieldData;
    private Query originalParentQuery;
    private final String parentType;
    private final Filter childrenFilter;
    private Query rewrittenParentQuery;
    private IndexReader rewriteIndexReader;

    public ParentConstantScoreQuery(ParentChildIndexFieldData parentChildIndexFieldData, Query parentQuery, String parentType, Filter childrenFilter) {
        this.parentChildIndexFieldData = parentChildIndexFieldData;
        this.originalParentQuery = parentQuery;
        this.parentType = parentType;
        this.childrenFilter = childrenFilter;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.rewrittenParentQuery == null) {
            this.rewrittenParentQuery = this.originalParentQuery.rewrite(reader);
            this.rewriteIndexReader = reader;
        }
        return this;
    }

    public void extractTerms(Set<Term> terms) {
        this.rewrittenParentQuery.extractTerms(terms);
    }

    public Query clone() {
        ParentConstantScoreQuery q = (ParentConstantScoreQuery)super.clone();
        q.originalParentQuery = this.originalParentQuery.clone();
        if (q.rewrittenParentQuery != null) {
            q.rewrittenParentQuery = this.rewrittenParentQuery.clone();
        }
        return q;
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        Query parentQuery;
        SearchContext searchContext = SearchContext.current();
        BytesRefHash parentIds = new BytesRefHash(512L, searchContext.bigArrays());
        ParentIdsCollector collector = new ParentIdsCollector(this.parentType, this.parentChildIndexFieldData, parentIds);
        if (this.rewrittenParentQuery != null) {
            parentQuery = this.rewrittenParentQuery;
        } else {
            assert (this.rewriteIndexReader == searcher.getIndexReader()) : "not equal, rewriteIndexReader=" + this.rewriteIndexReader + " searcher.getIndexReader()=" + searcher.getIndexReader();
            parentQuery = this.rewrittenParentQuery = this.originalParentQuery.rewrite(searcher.getIndexReader());
        }
        IndexSearcher indexSearcher = new IndexSearcher(searcher.getIndexReader());
        indexSearcher.setSimilarity(searcher.getSimilarity());
        indexSearcher.search(parentQuery, (Collector)collector);
        if (parentIds.size() == 0L) {
            Releasables.release(parentIds);
            return Queries.newMatchNoDocsQuery().createWeight(searcher);
        }
        ChildrenWeight childrenWeight = new ChildrenWeight(this.childrenFilter, parentIds);
        searchContext.addReleasable(childrenWeight);
        return childrenWeight;
    }

    public int hashCode() {
        int result = this.originalParentQuery.hashCode();
        result = 31 * result + this.parentType.hashCode();
        result = 31 * result + Float.floatToIntBits(this.getBoost());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        ParentConstantScoreQuery that = (ParentConstantScoreQuery)((Object)obj);
        if (!this.originalParentQuery.equals((Object)that.originalParentQuery)) {
            return false;
        }
        if (!this.parentType.equals(that.parentType)) {
            return false;
        }
        return this.getBoost() == that.getBoost();
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("parent_filter[").append(this.parentType).append("](").append(this.originalParentQuery).append(')');
        return sb.toString();
    }

    private static final class ParentIdsCollector
    extends NoopCollector {
        private final BytesRefHash parentIds;
        private final ParentChildIndexFieldData indexFieldData;
        private final String parentType;
        private BytesValues values;

        ParentIdsCollector(String parentType, ParentChildIndexFieldData indexFieldData, BytesRefHash parentIds) {
            this.parentIds = parentIds;
            this.indexFieldData = indexFieldData;
            this.parentType = parentType;
        }

        @Override
        public void collect(int doc) throws IOException {
            if (this.values != null) {
                this.values.setDocument(doc);
                this.parentIds.add(this.values.nextValue(), this.values.currentValueHash());
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext readerContext) throws IOException {
            this.values = ((ParentChildAtomicFieldData)this.indexFieldData.load(readerContext)).getBytesValues(this.parentType);
        }
    }

    private final class ChildrenWeight
    extends Weight
    implements Releasable {
        private final Filter childrenFilter;
        private final BytesRefHash parentIds;
        private float queryNorm;
        private float queryWeight;
        private FixedBitSet seenOrdinalsCache;
        private FixedBitSet seenMatchedOrdinalsCache;

        private ChildrenWeight(Filter childrenFilter, BytesRefHash parentIds) {
            this.childrenFilter = new ApplyAcceptedDocsFilter(childrenFilter);
            this.parentIds = parentIds;
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            return new Explanation(ParentConstantScoreQuery.this.getBoost(), "not implemented yet...");
        }

        public Query getQuery() {
            return ParentConstantScoreQuery.this;
        }

        public float getValueForNormalization() throws IOException {
            this.queryWeight = ParentConstantScoreQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float norm, float topLevelBoost) {
            this.queryNorm = norm * topLevelBoost;
            this.queryWeight *= this.queryNorm;
        }

        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            DocIdSetIterator innerIterator;
            DocIdSet childrenDocIdSet = this.childrenFilter.getDocIdSet(context, acceptDocs);
            if (DocIdSets.isEmpty(childrenDocIdSet)) {
                return null;
            }
            BytesValues.WithOrdinals bytesValues = ((ParentChildAtomicFieldData)ParentConstantScoreQuery.this.parentChildIndexFieldData.load(context)).getBytesValues(ParentConstantScoreQuery.this.parentType);
            if (bytesValues != null && (innerIterator = childrenDocIdSet.iterator()) != null) {
                Ordinals.Docs ordinals = bytesValues.ordinals();
                int maxOrd = (int)ordinals.getMaxOrd();
                if (this.seenOrdinalsCache == null || this.seenOrdinalsCache.length() < maxOrd) {
                    this.seenOrdinalsCache = new FixedBitSet(maxOrd);
                    this.seenMatchedOrdinalsCache = new FixedBitSet(maxOrd);
                } else {
                    this.seenOrdinalsCache.clear(0, maxOrd);
                    this.seenMatchedOrdinalsCache.clear(0, maxOrd);
                }
                ChildrenDocIdIterator childrenDocIdIterator = new ChildrenDocIdIterator(innerIterator, this.parentIds, bytesValues, ordinals, this.seenOrdinalsCache, this.seenMatchedOrdinalsCache);
                return ConstantScorer.create((DocIdSetIterator)childrenDocIdIterator, this, this.queryWeight);
            }
            return null;
        }

        @Override
        public boolean release() throws ElasticsearchException {
            Releasables.release(this.parentIds);
            return true;
        }

        private final class ChildrenDocIdIterator
        extends FilteredDocIdSetIterator {
            private final BytesRefHash parentIds;
            private final BytesValues.WithOrdinals bytesValues;
            private final Ordinals.Docs ordinals;
            private final FixedBitSet seenOrdinals;
            private final FixedBitSet seenMatchedOrdinals;

            ChildrenDocIdIterator(DocIdSetIterator innerIterator, BytesRefHash parentIds, BytesValues.WithOrdinals bytesValues, Ordinals.Docs ordinals, FixedBitSet seenOrdinals, FixedBitSet seenMatchedOrdinals) {
                super(innerIterator);
                this.parentIds = parentIds;
                this.bytesValues = bytesValues;
                this.ordinals = ordinals;
                this.seenOrdinals = seenOrdinals;
                this.seenMatchedOrdinals = seenMatchedOrdinals;
            }

            protected boolean match(int doc) {
                int ord = (int)this.ordinals.getOrd(doc);
                if ((long)ord == 0L) {
                    return false;
                }
                if (!this.seenOrdinals.get(ord)) {
                    this.seenOrdinals.set(ord);
                    if (this.parentIds.find(this.bytesValues.getValueByOrd(ord), this.bytesValues.currentValueHash()) >= 0L) {
                        this.seenMatchedOrdinals.set(ord);
                        return true;
                    }
                    return false;
                }
                return this.seenMatchedOrdinals.get(ord);
            }
        }
    }
}

