/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.distributor.Distributor;
import org.elasticsearch.index.store.distributor.LeastUsedDistributor;
import org.elasticsearch.index.store.distributor.RandomWeightedDistributor;

public class StoreModule
extends AbstractModule {
    private final Settings settings;
    private final IndexStore indexStore;
    private Class<? extends Distributor> distributor;

    public StoreModule(Settings settings, IndexStore indexStore) {
        this.indexStore = indexStore;
        this.settings = settings;
    }

    public void setDistributor(Class<? extends Distributor> distributor) {
        this.distributor = distributor;
    }

    @Override
    protected void configure() {
        this.bind(DirectoryService.class).to(this.indexStore.shardDirectory()).asEagerSingleton();
        this.bind(Store.class).asEagerSingleton();
        if (this.distributor == null) {
            this.distributor = this.loadDistributor(this.settings);
        }
        this.bind(Distributor.class).to(this.distributor).asEagerSingleton();
    }

    private Class<? extends Distributor> loadDistributor(Settings settings) {
        String type = settings.get("index.store.distributor");
        Class distributor = "least_used".equals(type) ? LeastUsedDistributor.class : ("random".equals(type) ? RandomWeightedDistributor.class : settings.getAsClass("index.store.distributor", LeastUsedDistributor.class, "org.elasticsearch.index.store.distributor.", "Distributor"));
        return distributor;
    }
}

