/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.fielddata.breaker;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class FieldDataBreakerStats
implements Streamable,
ToXContent {
    private long maximum;
    private long estimated;
    private double overhead;

    FieldDataBreakerStats() {
    }

    public FieldDataBreakerStats(long maximum, long estimated, double overhead) {
        this.maximum = maximum;
        this.estimated = estimated;
        this.overhead = overhead;
    }

    public long getMaximum() {
        return this.maximum;
    }

    public long getEstimated() {
        return this.estimated;
    }

    public double getOverhead() {
        return this.overhead;
    }

    public static FieldDataBreakerStats readOptionalCircuitBreakerStats(StreamInput in) throws IOException {
        FieldDataBreakerStats stats = in.readOptionalStreamable(new FieldDataBreakerStats());
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.maximum = in.readLong();
        this.estimated = in.readLong();
        this.overhead = in.readDouble();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.maximum);
        out.writeLong(this.estimated);
        out.writeDouble(this.overhead);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.BREAKER);
        builder.field(Fields.MAX, this.maximum);
        builder.field(Fields.MAX_HUMAN, (Object)new ByteSizeValue(this.maximum));
        builder.field(Fields.ESTIMATED, this.estimated);
        builder.field(Fields.ESTIMATED_HUMAN, (Object)new ByteSizeValue(this.estimated));
        builder.field(Fields.OVERHEAD, this.overhead);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString BREAKER = new XContentBuilderString("fielddata_breaker");
        static final XContentBuilderString MAX = new XContentBuilderString("maximum_size_in_bytes");
        static final XContentBuilderString MAX_HUMAN = new XContentBuilderString("maximum_size");
        static final XContentBuilderString ESTIMATED = new XContentBuilderString("estimated_size_in_bytes");
        static final XContentBuilderString ESTIMATED_HUMAN = new XContentBuilderString("estimated_size");
        static final XContentBuilderString OVERHEAD = new XContentBuilderString("overhead");

        Fields() {
        }
    }
}

