/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.fs;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.fs.FsBlobStore;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.index.snapshots.IndexShardRepository;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryName;
import org.elasticsearch.repositories.RepositorySettings;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;

public class FsRepository
extends BlobStoreRepository {
    public static final String TYPE = "fs";
    private final FsBlobStore blobStore;
    private ByteSizeValue chunkSize;
    private final BlobPath basePath;
    private boolean compress;

    @Inject
    public FsRepository(RepositoryName name, RepositorySettings repositorySettings, IndexShardRepository indexShardRepository) throws IOException {
        super(name.getName(), repositorySettings, indexShardRepository);
        String location = repositorySettings.settings().get("location", this.componentSettings.get("location"));
        if (location == null) {
            this.logger.warn("using local fs location for gateway, should be changed to be a shared location across nodes", new Object[0]);
            throw new RepositoryException(name.name(), "missing location");
        }
        File locationFile = new File(location);
        int concurrentStreams = repositorySettings.settings().getAsInt("concurrent_streams", this.componentSettings.getAsInt("concurrent_streams", (Integer)5));
        EsThreadPoolExecutor concurrentStreamPool = EsExecutors.newScaling(1, concurrentStreams, 60L, TimeUnit.SECONDS, EsExecutors.daemonThreadFactory(this.settings, "[fs_stream]"));
        this.blobStore = new FsBlobStore(this.componentSettings, concurrentStreamPool, locationFile);
        this.chunkSize = repositorySettings.settings().getAsBytesSize("chunk_size", this.componentSettings.getAsBytesSize("chunk_size", null));
        this.compress = repositorySettings.settings().getAsBoolean("compress", this.componentSettings.getAsBoolean("compress", (Boolean)false));
        this.basePath = BlobPath.cleanPath();
    }

    @Override
    protected BlobStore blobStore() {
        return this.blobStore;
    }

    @Override
    protected boolean isCompress() {
        return this.compress;
    }

    @Override
    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    @Override
    protected BlobPath basePath() {
        return this.basePath;
    }
}

