/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.cat;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.hppc.ObjectIntOpenHashMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.support.RestTable;

public class RestAllocationAction
extends AbstractCatAction {
    @Inject
    public RestAllocationAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_cat/allocation", this);
        controller.registerHandler(RestRequest.Method.GET, "/_cat/allocation/{nodes}", this);
    }

    @Override
    void documentation(StringBuilder sb) {
        sb.append("/_cat/allocation\n");
    }

    @Override
    public void doRequest(final RestRequest request, final RestChannel channel) {
        final String[] nodes = Strings.splitStringByCommaToArray(request.param("nodes"));
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.clear().routingTable(true);
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.masterNodeTimeout(request.paramAsTime("master_timeout", clusterStateRequest.masterNodeTimeout()));
        this.client.admin().cluster().state(clusterStateRequest, new ActionListener<ClusterStateResponse>(){

            @Override
            public void onResponse(final ClusterStateResponse state) {
                NodesStatsRequest statsRequest = new NodesStatsRequest(nodes);
                statsRequest.clear().fs(true);
                RestAllocationAction.this.client.admin().cluster().nodesStats(statsRequest, new ActionListener<NodesStatsResponse>(){

                    @Override
                    public void onResponse(NodesStatsResponse stats) {
                        try {
                            Table tab = RestAllocationAction.this.buildTable(request, state, stats);
                            channel.sendResponse(RestTable.buildResponse(tab, request, channel));
                        }
                        catch (Throwable e) {
                            this.onFailure(e);
                        }
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        try {
                            channel.sendResponse(new XContentThrowableRestResponse(request, e));
                        }
                        catch (IOException e1) {
                            RestAllocationAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                        }
                    }
                });
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestAllocationAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }

    @Override
    Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell("shards", "alias:s;text-align:right;desc:number of shards on node");
        table.addCell("disk.used", "alias:du,diskUsed;text-align:right;desc:disk used (total, not just ES)");
        table.addCell("disk.avail", "alias:da,diskAvail;text-align:right;desc:disk available");
        table.addCell("disk.total", "alias:dt,diskTotal;text-align:right;desc:total capacity of all volumes");
        table.addCell("disk.percent", "alias:dp,diskPercent;text-align:right;desc:percent disk used");
        table.addCell("host", "alias:h;desc:host of node");
        table.addCell("ip", "desc:ip of node");
        table.addCell("node", "alias:n;desc:name of node");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, ClusterStateResponse state, NodesStatsResponse stats) {
        ObjectIntOpenHashMap<String> allocs = new ObjectIntOpenHashMap<String>();
        for (ShardRouting shard : state.getState().routingTable().allShards(new String[0])) {
            String nodeId = "UNASSIGNED";
            if (shard.assignedToNode()) {
                nodeId = shard.currentNodeId();
            }
            allocs.addTo(nodeId, 1);
        }
        Table table = this.getTableWithHeader(request);
        for (NodeStats nodeStats : (NodeStats[])stats.getNodes()) {
            DiscoveryNode node = nodeStats.getNode();
            int shardCount = 0;
            if (allocs.containsKey(node.id())) {
                shardCount = allocs.lget();
            }
            ByteSizeValue total = nodeStats.getFs().getTotal().getTotal();
            ByteSizeValue avail = nodeStats.getFs().getTotal().getAvailable();
            long used = 0L;
            short diskPercent = -1;
            if (total.bytes() > 0L && (used = total.bytes() - avail.bytes()) >= 0L && avail.bytes() >= 0L) {
                diskPercent = (short)(used * 100L / (used + avail.bytes()));
            }
            table.startRow();
            table.addCell(shardCount);
            table.addCell(used < 0L ? null : new ByteSizeValue(used));
            table.addCell(avail.bytes() < 0L ? null : avail);
            table.addCell(total.bytes() < 0L ? null : total);
            table.addCell(diskPercent < 0 ? null : Short.valueOf(diskPercent));
            table.addCell(node == null ? null : node.getHostName());
            table.addCell(node == null ? null : node.getHostAddress());
            table.addCell(node == null ? "UNASSIGNED" : node.name());
            table.endRow();
        }
        if (allocs.containsKey("UNASSIGNED")) {
            table.startRow();
            table.addCell(allocs.lget());
            table.addCell(null);
            table.addCell(null);
            table.addCell(null);
            table.addCell(null);
            table.addCell(null);
            table.addCell(null);
            table.addCell("UNASSIGNED");
            table.endRow();
        }
        return table;
    }
}

