/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.deletebyquery;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequest;
import org.elasticsearch.action.deletebyquery.DeleteByQueryResponse;
import org.elasticsearch.action.deletebyquery.IndexDeleteByQueryResponse;
import org.elasticsearch.action.deletebyquery.ShardDeleteByQueryRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.QuerySourceBuilder;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestDeleteByQueryAction
extends BaseRestHandler {
    @Inject
    public RestDeleteByQueryAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/_query", this);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/{type}/_query", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(Strings.splitStringByCommaToArray(request.param("index")));
        deleteByQueryRequest.listenerThreaded(false);
        try {
            String consistencyLevel;
            if (request.hasContent()) {
                deleteByQueryRequest.source(request.content(), request.contentUnsafe());
            } else {
                String source = request.param("source");
                if (source != null) {
                    deleteByQueryRequest.source(source);
                } else {
                    QuerySourceBuilder querySourceBuilder = RestActions.parseQuerySource(request);
                    if (querySourceBuilder != null) {
                        deleteByQueryRequest.source(querySourceBuilder);
                    }
                }
            }
            deleteByQueryRequest.types(Strings.splitStringByCommaToArray(request.param("type")));
            deleteByQueryRequest.timeout(request.paramAsTime("timeout", ShardDeleteByQueryRequest.DEFAULT_TIMEOUT));
            deleteByQueryRequest.routing(request.param("routing"));
            String replicationType = request.param("replication");
            if (replicationType != null) {
                deleteByQueryRequest.replicationType(ReplicationType.fromString(replicationType));
            }
            if ((consistencyLevel = request.param("consistency")) != null) {
                deleteByQueryRequest.consistencyLevel(WriteConsistencyLevel.fromString(consistencyLevel));
            }
            deleteByQueryRequest.indicesOptions(IndicesOptions.fromRequest(request, deleteByQueryRequest.indicesOptions()));
        }
        catch (Exception e) {
            try {
                XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                channel.sendResponse(new XContentRestResponse(request, RestStatus.PRECONDITION_FAILED, builder.startObject().field("error", e.getMessage()).endObject()));
            }
            catch (IOException e1) {
                this.logger.error("Failed to send failure response", e1, new Object[0]);
            }
            return;
        }
        this.client.deleteByQuery(deleteByQueryRequest, new ActionListener<DeleteByQueryResponse>(){

            @Override
            public void onResponse(DeleteByQueryResponse result) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    RestStatus restStatus = result.status();
                    builder.startObject();
                    builder.startObject(Fields._INDICES);
                    for (IndexDeleteByQueryResponse indexDeleteByQueryResponse : result.getIndices().values()) {
                        builder.startObject(indexDeleteByQueryResponse.getIndex(), XContentBuilder.FieldCaseConversion.NONE);
                        builder.startObject(Fields._SHARDS);
                        builder.field(Fields.TOTAL, indexDeleteByQueryResponse.getTotalShards());
                        builder.field(Fields.SUCCESSFUL, indexDeleteByQueryResponse.getSuccessfulShards());
                        builder.field(Fields.FAILED, indexDeleteByQueryResponse.getFailedShards());
                        ShardOperationFailedException[] failures = indexDeleteByQueryResponse.getFailures();
                        if (failures != null && failures.length > 0) {
                            builder.startArray(Fields.FAILURES);
                            for (ShardOperationFailedException shardFailure : failures) {
                                builder.startObject();
                                builder.field(Fields.INDEX, shardFailure.index());
                                builder.field(Fields.SHARD, shardFailure.shardId());
                                builder.field(Fields.REASON, shardFailure.reason());
                                builder.endObject();
                            }
                            builder.endArray();
                        }
                        builder.endObject();
                        builder.endObject();
                    }
                    builder.endObject();
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, restStatus, builder));
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestDeleteByQueryAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }

    static final class Fields {
        static final XContentBuilderString _INDICES = new XContentBuilderString("_indices");
        static final XContentBuilderString _SHARDS = new XContentBuilderString("_shards");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString SUCCESSFUL = new XContentBuilderString("successful");
        static final XContentBuilderString FAILED = new XContentBuilderString("failed");
        static final XContentBuilderString FAILURES = new XContentBuilderString("failures");
        static final XContentBuilderString INDEX = new XContentBuilderString("index");
        static final XContentBuilderString SHARD = new XContentBuilderString("shard");
        static final XContentBuilderString REASON = new XContentBuilderString("reason");

        Fields() {
        }
    }
}

