/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.significant.BucketSignificancePriorityQueue;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.UnmappedSignificantTerms;

public abstract class InternalSignificantTerms
extends InternalAggregation
implements SignificantTerms,
ToXContent,
Streamable {
    protected int requiredSize;
    protected long minDocCount;
    protected Collection<Bucket> buckets;
    protected Map<String, Bucket> bucketMap;
    protected long subsetSize;
    protected long supersetSize;

    protected InternalSignificantTerms() {
    }

    protected InternalSignificantTerms(long subsetSize, long supersetSize, String name, int requiredSize, long minDocCount, Collection<Bucket> buckets) {
        super(name);
        this.requiredSize = requiredSize;
        this.minDocCount = minDocCount;
        this.buckets = buckets;
        this.subsetSize = subsetSize;
        this.supersetSize = supersetSize;
    }

    @Override
    public Iterator<SignificantTerms.Bucket> iterator() {
        Iterator<SignificantTerms.Bucket> o = this.buckets.iterator();
        return o;
    }

    @Override
    public Collection<SignificantTerms.Bucket> getBuckets() {
        Collection<SignificantTerms.Bucket> o = this.buckets;
        return o;
    }

    @Override
    public SignificantTerms.Bucket getBucketByKey(String term) {
        if (this.bucketMap == null) {
            this.bucketMap = Maps.newHashMapWithExpectedSize(this.buckets.size());
            for (Bucket bucket : this.buckets) {
                this.bucketMap.put(bucket.getKey(), bucket);
            }
        }
        return this.bucketMap.get(term);
    }

    @Override
    public InternalSignificantTerms reduce(InternalAggregation.ReduceContext reduceContext) {
        List<InternalAggregation> aggregations = reduceContext.aggregations();
        if (aggregations.size() == 1) {
            InternalSignificantTerms terms = (InternalSignificantTerms)aggregations.get(0);
            terms.trimExcessEntries();
            return terms;
        }
        InternalSignificantTerms reduced = null;
        long globalSubsetSize = 0L;
        long globalSupersetSize = 0L;
        for (InternalAggregation aggregation : aggregations) {
            InternalSignificantTerms terms = (InternalSignificantTerms)aggregation;
            globalSubsetSize += terms.subsetSize;
            globalSupersetSize += terms.supersetSize;
        }
        HashMap buckets = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalSignificantTerms terms = (InternalSignificantTerms)aggregation;
            if (terms instanceof UnmappedSignificantTerms) continue;
            if (reduced == null) {
                reduced = terms;
            }
            if (buckets == null) {
                buckets = new HashMap(terms.buckets.size());
            }
            for (Bucket bucket : terms.buckets) {
                ArrayList<Bucket> existingBuckets = (ArrayList<Bucket>)buckets.get(bucket.getKey());
                if (existingBuckets == null) {
                    existingBuckets = new ArrayList<Bucket>(aggregations.size());
                    buckets.put(bucket.getKey(), existingBuckets);
                }
                bucket.subsetSize = globalSubsetSize;
                bucket.supersetSize = globalSupersetSize;
                bucket.updateScore();
                existingBuckets.add(bucket);
            }
        }
        if (reduced == null) {
            return (UnmappedSignificantTerms)aggregations.get(0);
        }
        int size = Math.min(this.requiredSize, buckets.size());
        BucketSignificancePriorityQueue ordered = new BucketSignificancePriorityQueue(size);
        for (Map.Entry entry : buckets.entrySet()) {
            List sameTermBuckets = (List)entry.getValue();
            Bucket b = ((Bucket)sameTermBuckets.get(0)).reduce(sameTermBuckets, reduceContext.bigArrays());
            if (!(b.score > 0.0) || b.subsetDf < this.minDocCount) continue;
            ordered.insertWithOverflow(b);
        }
        Bucket[] list = new Bucket[ordered.size()];
        for (int i = ordered.size() - 1; i >= 0; --i) {
            list[i] = (Bucket)ordered.pop();
        }
        reduced.buckets = Arrays.asList(list);
        reduced.subsetSize = globalSubsetSize;
        reduced.supersetSize = globalSupersetSize;
        return reduced;
    }

    final void trimExcessEntries() {
        ArrayList<Bucket> newBuckets = Lists.newArrayList();
        for (Bucket b : this.buckets) {
            if (newBuckets.size() >= this.requiredSize) break;
            if (b.subsetDf < this.minDocCount) continue;
            newBuckets.add(b);
        }
        this.buckets = newBuckets;
    }

    public static abstract class Bucket
    extends SignificantTerms.Bucket {
        long bucketOrd;
        protected InternalAggregations aggregations;
        double score;

        protected Bucket(long subsetDf, long subsetSize, long supersetDf, long supersetSize, InternalAggregations aggregations) {
            super(subsetDf, subsetSize, supersetDf, supersetSize);
            this.aggregations = aggregations;
            assert (subsetDf <= supersetDf);
            this.updateScore();
        }

        @Override
        public long getSubsetDf() {
            return this.subsetDf;
        }

        @Override
        public long getSupersetDf() {
            return this.supersetDf;
        }

        @Override
        public long getSupersetSize() {
            return this.supersetSize;
        }

        @Override
        public long getSubsetSize() {
            return this.subsetSize;
        }

        public static double getSampledTermSignificance(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
            if (subsetSize == 0L || supersetSize == 0L) {
                return 0.0;
            }
            double subsetProbability = (double)subsetFreq / (double)subsetSize;
            double supersetProbability = (double)supersetFreq / (double)supersetSize;
            double absoluteProbabilityChange = subsetProbability - supersetProbability;
            if (absoluteProbabilityChange <= 0.0) {
                return 0.0;
            }
            double relativeProbabilityChange = subsetProbability / supersetProbability;
            return absoluteProbabilityChange * relativeProbabilityChange;
        }

        public void updateScore() {
            this.score = Bucket.getSampledTermSignificance(this.subsetDf, this.subsetSize, this.supersetDf, this.supersetSize);
        }

        @Override
        public long getDocCount() {
            return this.subsetDf;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        public Bucket reduce(List<? extends Bucket> buckets, BigArrays bigArrays) {
            if (buckets.size() == 1) {
                return buckets.get(0);
            }
            Bucket reduced = null;
            ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
            for (Bucket bucket : buckets) {
                if (reduced == null) {
                    reduced = bucket;
                } else {
                    reduced.subsetDf += bucket.subsetDf;
                    reduced.supersetDf += bucket.supersetDf;
                    reduced.updateScore();
                }
                aggregationsList.add(bucket.aggregations);
            }
            assert (reduced.subsetDf <= reduced.supersetDf);
            reduced.aggregations = InternalAggregations.reduce(aggregationsList, bigArrays);
            return reduced;
        }

        @Override
        public double getSignificanceScore() {
            return this.score;
        }
    }
}

