/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FilterAtomicReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantLongTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantStringTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.significant.UnmappedSignificantTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValueSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.bytes.BytesValuesSource;
import org.elasticsearch.search.aggregations.support.numeric.NumericValuesSource;
import org.elasticsearch.search.internal.SearchContext;

public class SignificantTermsAggregatorFactory
extends ValueSourceAggregatorFactory
implements Releasable {
    public static final String EXECUTION_HINT_VALUE_MAP = "map";
    public static final String EXECUTION_HINT_VALUE_ORDINALS = "ordinals";
    static final int INITIAL_NUM_TERM_FREQS_CACHED = 512;
    private final int requiredSize;
    private final int shardSize;
    private final long minDocCount;
    private final IncludeExclude includeExclude;
    private final String executionHint;
    private String indexedFieldName;
    private FieldMapper mapper;
    private IntArray termDocFreqs;
    private BytesRefHash cachedTermOrds;
    private BigArrays bigArrays;
    private TermsEnum termsEnum;
    private int numberOfAggregatorsCreated = 0;

    public SignificantTermsAggregatorFactory(String name, ValuesSourceConfig valueSourceConfig, int requiredSize, int shardSize, long minDocCount, IncludeExclude includeExclude, String executionHint) {
        super(name, SignificantStringTerms.TYPE.name(), valueSourceConfig);
        this.requiredSize = requiredSize;
        this.shardSize = shardSize;
        this.minDocCount = minDocCount;
        this.includeExclude = includeExclude;
        this.executionHint = executionHint;
        if (!valueSourceConfig.unmapped()) {
            this.indexedFieldName = this.valuesSourceConfig.fieldContext().field();
            this.mapper = SearchContext.current().smartNameFieldMapper(this.indexedFieldName);
        }
        this.bigArrays = SearchContext.current().bigArrays();
    }

    @Override
    protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
        return new UnmappedSignificantTermsAggregator(this.name, this.requiredSize, this.minDocCount, aggregationContext, parent, this);
    }

    private static boolean hasParentBucketAggregator(Aggregator parent) {
        if (parent == null) {
            return false;
        }
        if (parent.bucketAggregationMode() == Aggregator.BucketAggregationMode.PER_BUCKET) {
            return true;
        }
        return SignificantTermsAggregatorFactory.hasParentBucketAggregator(parent.parent());
    }

    /*
     * Unable to fully structure code
     */
    protected Aggregator create(ValuesSource valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
        ++this.numberOfAggregatorsCreated;
        if (this.numberOfAggregatorsCreated == 1) {
            try {
                searchContext = aggregationContext.searchContext();
                searcher = searchContext.searcher();
                terms = MultiFields.getTerms((IndexReader)searcher.getIndexReader(), (String)this.indexedFieldName);
                if (terms == null) ** GOTO lbl15
                this.termsEnum = terms.iterator(null);
            }
            catch (IOException e) {
                throw new ElasticsearchException("IOException loading background document frequency info", e);
            }
        } else if (this.numberOfAggregatorsCreated == 2 && this.termsEnum != null) {
            searchContext = aggregationContext.searchContext();
            this.termsEnum = new FrequencyCachingTermsEnumWrapper(this.termsEnum, searchContext.bigArrays(), true, false);
        }
lbl15:
        // 5 sources

        estimatedBucketCount = valuesSource.metaData().maxAtomicUniqueValuesCount();
        if (estimatedBucketCount < 0L) {
            estimatedBucketCount = 50L;
        }
        estimatedBucketCount = Math.min(estimatedBucketCount, 512L);
        if (valuesSource instanceof BytesValuesSource) {
            if (this.executionHint != null && !this.executionHint.equals("map") && !this.executionHint.equals("ordinals")) {
                throw new ElasticsearchIllegalArgumentException("execution_hint can only be 'map' or 'ordinals', not " + this.executionHint);
            }
            execution = this.executionHint;
            if (!(valuesSource instanceof BytesValuesSource.WithOrdinals)) {
                execution = "map";
            } else if (this.includeExclude != null) {
                execution = "map";
            }
            if (execution == null) {
                execution = valuesSource instanceof BytesValuesSource.WithOrdinals != false && SignificantTermsAggregatorFactory.hasParentBucketAggregator(parent) == false ? "ordinals" : "map";
            }
            if (!SignificantTermsAggregatorFactory.$assertionsDisabled && execution == null) {
                throw new AssertionError();
            }
            if (execution.equals("ordinals")) {
                if (!SignificantTermsAggregatorFactory.$assertionsDisabled && this.includeExclude != null) {
                    throw new AssertionError();
                }
                return new SignificantStringTermsAggregator.WithOrdinals(this.name, this.factories, (BytesValuesSource.WithOrdinals)valuesSource, estimatedBucketCount, this.requiredSize, this.shardSize, this.minDocCount, aggregationContext, parent, this);
            }
            return new SignificantStringTermsAggregator(this.name, this.factories, valuesSource, estimatedBucketCount, this.requiredSize, this.shardSize, this.minDocCount, this.includeExclude, aggregationContext, parent, this);
        }
        if (this.includeExclude != null) {
            throw new AggregationExecutionException("Aggregation [" + this.name + "] cannot support the include/exclude " + "settings as it can only be applied to string values");
        }
        if (valuesSource instanceof NumericValuesSource) {
            if (((NumericValuesSource)valuesSource).isFloatingPoint()) {
                throw new UnsupportedOperationException("No support for examining floating point numerics");
            }
            return new SignificantLongTermsAggregator(this.name, this.factories, (NumericValuesSource)valuesSource, estimatedBucketCount, this.requiredSize, this.shardSize, this.minDocCount, aggregationContext, parent, this);
        }
        throw new AggregationExecutionException("sigfnificant_terms aggregation cannot be applied to field [" + this.valuesSourceConfig.fieldContext().field() + "]. It can only be applied to numeric or string fields.");
    }

    public long getBackgroundFrequency(BytesRef termBytes) {
        assert (this.termsEnum != null);
        long result = 0L;
        try {
            if (this.termsEnum.seekExact(termBytes)) {
                result = this.termsEnum.docFreq();
            }
        }
        catch (IOException e) {
            throw new ElasticsearchException("IOException loading background document frequency info", e);
        }
        return result;
    }

    public long getBackgroundFrequency(long term) {
        BytesRef indexedVal = this.mapper.indexedValueForSearch(term);
        return this.getBackgroundFrequency(indexedVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean release() throws ElasticsearchException {
        try {
            if (this.termsEnum instanceof Releasable) {
                ((Releasable)this.termsEnum).release();
            }
        }
        finally {
            this.termsEnum = null;
        }
        return true;
    }

    static class FrequencyCachingTermsEnumWrapper
    extends FilterAtomicReader.FilterTermsEnum
    implements Releasable {
        int currentTermDocFreq = 0;
        long currentTermTotalFreq = 0L;
        private IntArray termDocFreqs;
        private LongArray termTotalFreqs;
        private BytesRefHash cachedTermOrds;
        protected BigArrays bigArrays;
        private boolean cacheDocFreqs;
        private boolean cacheTotalFreqs;
        private long currentTermOrd;

        public FrequencyCachingTermsEnumWrapper(TermsEnum delegate, BigArrays bigArrays, boolean cacheDocFreqs, boolean cacheTotalFreqs) {
            super(delegate);
            this.bigArrays = bigArrays;
            this.cacheDocFreqs = cacheDocFreqs;
            this.cacheTotalFreqs = cacheTotalFreqs;
            if (cacheDocFreqs) {
                this.termDocFreqs = bigArrays.newIntArray(512L, false);
            }
            if (cacheTotalFreqs) {
                this.termTotalFreqs = bigArrays.newLongArray(512L, false);
            }
            this.cachedTermOrds = new BytesRefHash(512L, bigArrays);
        }

        public boolean seekExact(BytesRef text) throws IOException {
            this.currentTermDocFreq = 0;
            this.currentTermTotalFreq = 0L;
            this.currentTermOrd = this.cachedTermOrds.add(text);
            if (this.currentTermOrd < 0L) {
                this.currentTermOrd = -1L - this.currentTermOrd;
                if (this.cacheDocFreqs) {
                    this.currentTermDocFreq = this.termDocFreqs.get(this.currentTermOrd);
                }
                if (this.cacheTotalFreqs) {
                    this.currentTermTotalFreq = this.termTotalFreqs.get(this.currentTermOrd);
                }
                return true;
            }
            if (this.in.seekExact(text)) {
                if (this.cacheDocFreqs) {
                    this.currentTermDocFreq = this.in.docFreq();
                    this.termDocFreqs = this.bigArrays.grow(this.termDocFreqs, this.currentTermOrd + 1L);
                    this.termDocFreqs.set(this.currentTermOrd, this.currentTermDocFreq);
                }
                if (this.cacheTotalFreqs) {
                    this.currentTermTotalFreq = this.in.totalTermFreq();
                    this.termTotalFreqs = this.bigArrays.grow(this.termTotalFreqs, this.currentTermOrd + 1L);
                    this.termTotalFreqs.set(this.currentTermOrd, this.currentTermTotalFreq);
                }
                return true;
            }
            return false;
        }

        public long totalTermFreq() throws IOException {
            assert (this.cacheTotalFreqs);
            return this.currentTermTotalFreq;
        }

        public int docFreq() throws IOException {
            assert (this.cacheDocFreqs);
            return this.currentTermDocFreq;
        }

        public void seekExact(long ord) throws IOException {
            throw new UnsupportedOperationException();
        }

        public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            throw new UnsupportedOperationException();
        }

        public BytesRef next() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean release() throws ElasticsearchException {
            try {
                Releasables.release(this.cachedTermOrds, this.termDocFreqs, this.termTotalFreqs);
            }
            finally {
                this.cachedTermOrds = null;
                this.termDocFreqs = null;
                this.termTotalFreqs = null;
            }
            return true;
        }
    }
}

