/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles.tdigest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.hppc.cursors.IntCursor;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.GroupRedBlackTree;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.RedBlackTree;

public class TDigestState {
    private final Random gen;
    private double compression = 100.0;
    private GroupRedBlackTree summary;
    private long count = 0L;
    private final GroupRedBlackTree.SizeAndSum sizeAndSum = new GroupRedBlackTree.SizeAndSum();

    public TDigestState(double compression) {
        this.compression = compression;
        this.gen = new Random();
        this.summary = new GroupRedBlackTree((int)compression);
    }

    public void add(double x) {
        this.add(x, 1L);
    }

    public void add(double x, long w) {
        int startNode = this.summary.floorNode(x);
        if (startNode == 0) {
            startNode = this.summary.ceilingNode(x);
        }
        if (startNode == 0) {
            this.summary.addGroup(x, w);
            this.count = w;
        } else {
            double z;
            int headSize;
            double minDistance = Double.POSITIVE_INFINITY;
            int lastNeighbor = 0;
            this.summary.headSum(startNode, this.sizeAndSum);
            int i = headSize = this.sizeAndSum.size;
            int node = startNode;
            while (node != 0 && (z = Math.abs(this.summary.mean(node) - x)) <= minDistance) {
                minDistance = z;
                lastNeighbor = i++;
                node = this.summary.nextNode(node);
            }
            int closest = 0;
            long sum = this.sizeAndSum.sum;
            double n = 1.0;
            int node2 = startNode;
            for (i = headSize; node2 != 0 && i <= lastNeighbor; ++i) {
                double z2 = Math.abs(this.summary.mean(node2) - x);
                double q = ((double)sum + (double)this.summary.count(node2) / 2.0) / (double)this.count;
                double k = (double)(4L * this.count) * q * (1.0 - q) / this.compression;
                if (z2 == minDistance && (double)(this.summary.count(node2) + w) <= k) {
                    if (this.gen.nextDouble() < 1.0 / n) {
                        closest = node2;
                    }
                    n += 1.0;
                }
                sum += this.summary.count(node2);
                node2 = this.summary.nextNode(node2);
            }
            if (closest == 0) {
                this.summary.addGroup(x, w);
            } else {
                double centroid = this.summary.mean(closest);
                long count = this.summary.count(closest);
                centroid += (double)w * (x - centroid) / (double)(count += w);
                this.summary.updateGroup(closest, centroid, count);
            }
            this.count += w;
            if ((double)this.summary.size() > 100.0 * this.compression) {
                this.compress();
            }
        }
    }

    private int[] shuffleNodes(RedBlackTree tree) {
        int[] nodes = new int[tree.size()];
        int i = 0;
        for (IntCursor cursor : tree) {
            nodes[i++] = cursor.value;
        }
        assert (i == tree.size());
        for (i = tree.size() - 1; i > 0; --i) {
            int slot = this.gen.nextInt(i + 1);
            int tmp = nodes[slot];
            nodes[slot] = nodes[i];
            nodes[i] = tmp;
        }
        return nodes;
    }

    public void add(TDigestState other) {
        int[] shuffledNodes;
        for (int node : shuffledNodes = this.shuffleNodes(other.summary)) {
            this.add(other.summary.mean(node), other.summary.count(node));
        }
    }

    public static TDigestState merge(double compression, Iterable<TDigestState> subData) {
        Preconditions.checkArgument(subData.iterator().hasNext(), "Can't merge 0 digests");
        ArrayList<TDigestState> elements = Lists.newArrayList(subData);
        int n = Math.max(1, elements.size() / 4);
        TDigestState r = new TDigestState(compression);
        for (int i = 0; i < elements.size(); i += n) {
            if (n > 1) {
                r.add(TDigestState.merge(compression, elements.subList(i, Math.min(i + n, elements.size()))));
                continue;
            }
            r.add((TDigestState)elements.get(i));
        }
        return r;
    }

    public void compress() {
        this.compress(this.summary);
    }

    private void compress(GroupRedBlackTree other) {
        int[] shuffledNodes;
        TDigestState reduced = new TDigestState(this.compression);
        for (int node : shuffledNodes = this.shuffleNodes(other)) {
            reduced.add(other.mean(node), other.count(node));
        }
        this.summary = reduced.summary;
    }

    public long size() {
        return this.count;
    }

    public GroupRedBlackTree centroids() {
        return this.summary;
    }

    public double cdf(double x) {
        double left;
        GroupRedBlackTree values = this.summary;
        if (values.size() == 0) {
            return Double.NaN;
        }
        if (values.size() == 1) {
            return x < values.mean(values.root()) ? 0.0 : 1.0;
        }
        double r = 0.0;
        Iterator<IntCursor> it = values.iterator();
        int a = it.next().value;
        int b = it.next().value;
        double right = left = (values.mean(b) - values.mean(a)) / 2.0;
        while (it.hasNext()) {
            if (x < values.mean(a) + right) {
                return (r + (double)values.count(a) * this.interpolate(x, values.mean(a) - left, values.mean(a) + right)) / (double)this.count;
            }
            r += (double)values.count(a);
            a = b;
            b = it.next().value;
            left = right;
            right = (values.mean(b) - values.mean(a)) / 2.0;
        }
        left = right;
        a = b;
        if (x < values.mean(a) + right) {
            return (r + (double)values.count(a) * this.interpolate(x, values.mean(a) - left, values.mean(a) + right)) / (double)this.count;
        }
        return 1.0;
    }

    public double quantile(double q) {
        if (q < 0.0 || q > 1.0) {
            throw new ElasticsearchIllegalArgumentException("q should be in [0,1], got " + q);
        }
        GroupRedBlackTree values = this.summary;
        if (values.size() == 0) {
            return Double.NaN;
        }
        if (values.size() == 1) {
            return values.mean(values.root());
        }
        double index = q * (double)(this.count - 1L);
        double previousMean = Double.NaN;
        double previousIndex = 0.0;
        long total = 0L;
        Iterator<IntCursor> it = this.centroids().iterator();
        while (true) {
            int next;
            double nextIndex;
            if ((nextIndex = (double)total + ((double)values.count(next = it.next().value) - 1.0) / 2.0) >= index) {
                if (Double.isNaN(previousMean)) {
                    if (nextIndex == previousIndex) {
                        return values.mean(next);
                    }
                    int next2 = it.next().value;
                    double nextIndex2 = (double)(total + values.count(next)) + ((double)values.count(next2) - 1.0) / 2.0;
                    previousMean = (nextIndex2 * values.mean(next) - nextIndex * values.mean(next2)) / (nextIndex2 - nextIndex);
                }
                return TDigestState.quantile(previousIndex, index, nextIndex, previousMean, values.mean(next));
            }
            if (!it.hasNext()) {
                double nextIndex2 = this.count - 1L;
                double nextMean2 = (values.mean(next) * (nextIndex2 - previousIndex) - previousMean * (nextIndex2 - nextIndex)) / (nextIndex - previousIndex);
                return TDigestState.quantile(nextIndex, index, nextIndex2, values.mean(next), nextMean2);
            }
            total += values.count(next);
            previousMean = values.mean(next);
            previousIndex = nextIndex;
        }
    }

    private static double quantile(double previousIndex, double index, double nextIndex, double previousMean, double nextMean) {
        double delta = nextIndex - previousIndex;
        double previousWeight = (nextIndex - index) / delta;
        double nextWeight = (index - previousIndex) / delta;
        return previousMean * previousWeight + nextMean * nextWeight;
    }

    public int centroidCount() {
        return this.summary.size();
    }

    public double compression() {
        return this.compression;
    }

    private double interpolate(double x, double x0, double x1) {
        return (x - x0) / (x1 - x0);
    }

    public static void write(TDigestState state, StreamOutput out) throws IOException {
        out.writeDouble(state.compression);
        out.writeVInt(state.summary.size());
        for (IntCursor cursor : state.summary) {
            int node = cursor.value;
            out.writeDouble(state.summary.mean(node));
            out.writeVLong(state.summary.count(node));
        }
    }

    public static TDigestState read(StreamInput in) throws IOException {
        double compression = in.readDouble();
        TDigestState state = new TDigestState(compression);
        int n = in.readVInt();
        for (int i = 0; i < n; ++i) {
            state.add(in.readDouble(), in.readVInt());
        }
        return state;
    }
}

