/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.StoredFieldVisitor;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.index.fieldvisitor.SingleFieldsVisitor;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.lookup.FieldLookup;

public class FieldsLookup
implements Map {
    private final MapperService mapperService;
    @Nullable
    private final String[] types;
    private AtomicReader reader;
    private int docId = -1;
    private final Map<String, FieldLookup> cachedFieldData = Maps.newHashMap();
    private final SingleFieldsVisitor fieldVisitor;

    FieldsLookup(MapperService mapperService, @Nullable String[] types) {
        this.mapperService = mapperService;
        this.types = types;
        this.fieldVisitor = new SingleFieldsVisitor(null);
    }

    public void setNextReader(AtomicReaderContext context) {
        if (this.reader == context.reader()) {
            return;
        }
        this.reader = context.reader();
        this.clearCache();
        this.docId = -1;
    }

    public void setNextDocId(int docId) {
        if (this.docId == docId) {
            return;
        }
        this.docId = docId;
        this.clearCache();
    }

    public Object get(Object key) {
        return this.loadFieldData(key.toString());
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            this.loadFieldData(key.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    private FieldLookup loadFieldData(String name) {
        FieldLookup data = this.cachedFieldData.get(name);
        if (data == null) {
            FieldMapper mapper = this.mapperService.smartNameFieldMapper(name, this.types);
            if (mapper == null) {
                throw new ElasticsearchIllegalArgumentException("No field found for [" + name + "] in mapping with types " + Arrays.toString(this.types) + "");
            }
            data = new FieldLookup(mapper);
            this.cachedFieldData.put(name, data);
        }
        if (data.fields() == null) {
            String fieldName = data.mapper().names().indexName();
            this.fieldVisitor.reset(fieldName);
            try {
                this.reader.document(this.docId, (StoredFieldVisitor)this.fieldVisitor);
                this.fieldVisitor.postProcess(data.mapper());
                data.fields(ImmutableMap.of(name, this.fieldVisitor.fields().get(data.mapper().names().indexName())));
            }
            catch (IOException e) {
                throw new ElasticsearchParseException("failed to load field [" + name + "]", e);
            }
        }
        return data;
    }

    private void clearCache() {
        for (Map.Entry<String, FieldLookup> entry : this.cachedFieldData.entrySet()) {
            entry.getValue().clear();
        }
    }
}

