/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rescore;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IntroSorter;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.rescore.RescoreSearchContext;
import org.elasticsearch.search.rescore.Rescorer;

public final class QueryRescorer
implements Rescorer {
    public static final Rescorer INSTANCE = new QueryRescorer();
    public static final String NAME = "query";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void rescore(TopDocs topDocs, SearchContext context, RescoreSearchContext rescoreContext) throws IOException {
        assert (rescoreContext != null);
        if (topDocs == null || topDocs.totalHits == 0 || topDocs.scoreDocs.length == 0) {
            return;
        }
        QueryRescoreContext rescore = (QueryRescoreContext)rescoreContext;
        ContextIndexSearcher searcher = context.searcher();
        TopDocsFilter filter = new TopDocsFilter(topDocs, rescoreContext.window());
        TopDocs rescored = searcher.search(rescore.query(), filter, rescoreContext.window());
        context.queryResult().topDocs(this.merge(topDocs, rescored, rescore));
    }

    @Override
    public Explanation explain(int topLevelDocId, SearchContext context, RescoreSearchContext rescoreContext, Explanation sourceExplanation) throws IOException {
        QueryRescoreContext rescore = (QueryRescoreContext)rescoreContext;
        ContextIndexSearcher searcher = context.searcher();
        if (sourceExplanation == null) {
            return new ComplexExplanation(false, 0.0f, "nothing matched");
        }
        Explanation rescoreExplain = searcher.explain(rescore.query(), topLevelDocId);
        float primaryWeight = rescore.queryWeight();
        ComplexExplanation prim = new ComplexExplanation(sourceExplanation.isMatch(), sourceExplanation.getValue() * primaryWeight, "product of:");
        prim.addDetail(sourceExplanation);
        prim.addDetail(new Explanation(primaryWeight, "primaryWeight"));
        if (rescoreExplain != null && rescoreExplain.isMatch()) {
            float secondaryWeight = rescore.rescoreQueryWeight();
            ComplexExplanation sec = new ComplexExplanation(rescoreExplain.isMatch(), rescoreExplain.getValue() * secondaryWeight, "product of:");
            sec.addDetail(rescoreExplain);
            sec.addDetail(new Explanation(secondaryWeight, "secondaryWeight"));
            ScoreMode scoreMode = rescore.scoreMode();
            ComplexExplanation calcExpl = new ComplexExplanation();
            calcExpl.setDescription((Object)((Object)scoreMode) + " of:");
            calcExpl.addDetail((Explanation)prim);
            calcExpl.setMatch(Boolean.valueOf(prim.isMatch()));
            calcExpl.addDetail((Explanation)sec);
            calcExpl.setValue(scoreMode.combine(prim.getValue(), sec.getValue()));
            return calcExpl;
        }
        return prim;
    }

    @Override
    public RescoreSearchContext parse(XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        QueryRescoreContext rescoreContext = new QueryRescoreContext(this);
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                if (!"rescore_query".equals(fieldName)) continue;
                ParsedQuery parsedQuery = context.queryParserService().parse(parser);
                rescoreContext.setParsedQuery(parsedQuery);
                continue;
            }
            if (!token.isValue()) continue;
            if ("query_weight".equals(fieldName)) {
                rescoreContext.setQueryWeight(parser.floatValue());
                continue;
            }
            if ("rescore_query_weight".equals(fieldName)) {
                rescoreContext.setRescoreQueryWeight(parser.floatValue());
                continue;
            }
            if ("score_mode".equals(fieldName)) {
                String sScoreMode = parser.text();
                if ("avg".equals(sScoreMode)) {
                    rescoreContext.setScoreMode(ScoreMode.Avg);
                    continue;
                }
                if ("max".equals(sScoreMode)) {
                    rescoreContext.setScoreMode(ScoreMode.Max);
                    continue;
                }
                if ("min".equals(sScoreMode)) {
                    rescoreContext.setScoreMode(ScoreMode.Min);
                    continue;
                }
                if ("total".equals(sScoreMode)) {
                    rescoreContext.setScoreMode(ScoreMode.Total);
                    continue;
                }
                if ("multiply".equals(sScoreMode)) {
                    rescoreContext.setScoreMode(ScoreMode.Multiply);
                    continue;
                }
                throw new ElasticsearchIllegalArgumentException("[rescore] illegal score_mode [" + sScoreMode + "]");
            }
            throw new ElasticsearchIllegalArgumentException("rescore doesn't support [" + fieldName + "]");
        }
        return rescoreContext;
    }

    private TopDocs merge(TopDocs primary, TopDocs secondary, QueryRescoreContext context) {
        DocIdSorter sorter = new DocIdSorter();
        DocIdSorter.access$202(sorter, primary.scoreDocs);
        sorter.sort(0, sorter.array.length);
        ScoreDoc[] primaryDocs = sorter.array;
        DocIdSorter.access$202(sorter, secondary.scoreDocs);
        sorter.sort(0, sorter.array.length);
        ScoreDoc[] secondaryDocs = sorter.array;
        int j = 0;
        float primaryWeight = context.queryWeight();
        float secondaryWeight = context.rescoreQueryWeight();
        ScoreMode scoreMode = context.scoreMode();
        for (int i = 0; i < primaryDocs.length; ++i) {
            if (j < secondaryDocs.length && primaryDocs[i].doc == secondaryDocs[j].doc) {
                primaryDocs[i].score = scoreMode.combine(primaryDocs[i].score * primaryWeight, secondaryDocs[j++].score * secondaryWeight);
                continue;
            }
            primaryDocs[i].score *= primaryWeight;
        }
        ScoreSorter scoreSorter = new ScoreSorter();
        ScoreSorter.access$402(scoreSorter, primaryDocs);
        scoreSorter.sort(0, primaryDocs.length);
        primary.setMaxScore(primaryDocs[0].score);
        return primary;
    }

    private static final int compareDocId(ScoreDoc left, ScoreDoc right) {
        if (left.doc < right.doc) {
            return 1;
        }
        if (left.doc == right.doc) {
            return 0;
        }
        return -1;
    }

    @Override
    public void extractTerms(SearchContext context, RescoreSearchContext rescoreContext, Set<Term> termsSet) {
        ((QueryRescoreContext)rescoreContext).query().extractTerms(termsSet);
    }

    private static final class TopDocsFilter
    extends Filter {
        private final int[] docIds;

        public TopDocsFilter(TopDocs topDocs, int max) {
            ScoreDoc[] scoreDocs = topDocs.scoreDocs;
            max = Math.min(max, scoreDocs.length);
            this.docIds = new int[max];
            for (int i = 0; i < max; ++i) {
                this.docIds[i] = scoreDocs[i].doc;
            }
            Arrays.sort(this.docIds);
        }

        public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            int end;
            final int docBase = context.docBase;
            int limit = docBase + context.reader().maxDoc();
            int offset = Arrays.binarySearch(this.docIds, docBase);
            if (offset < 0) {
                offset = -offset - 1;
            }
            if ((end = Arrays.binarySearch(this.docIds, limit)) < 0) {
                end = -end - 1;
            }
            final int start = offset;
            final int stop = end;
            return new DocIdSet(){

                public DocIdSetIterator iterator() throws IOException {
                    return new DocIdSetIterator(){
                        private int current;
                        private int docId;
                        {
                            this.current = start;
                            this.docId = Integer.MAX_VALUE;
                        }

                        public int nextDoc() throws IOException {
                            if (this.current < stop) {
                                this.docId = TopDocsFilter.this.docIds[this.current++] - docBase;
                                return this.docId;
                            }
                            this.docId = Integer.MAX_VALUE;
                            return Integer.MAX_VALUE;
                        }

                        public int docID() {
                            return this.docId;
                        }

                        public int advance(int target) throws IOException {
                            if (target == Integer.MAX_VALUE) {
                                this.current = stop;
                                this.docId = Integer.MAX_VALUE;
                                return Integer.MAX_VALUE;
                            }
                            while (this.nextDoc() < target) {
                            }
                            return this.docId;
                        }

                        public long cost() {
                            return TopDocsFilter.this.docIds.length;
                        }
                    };
                }
            };
        }
    }

    private static final class ScoreSorter
    extends IntroSorter {
        private ScoreDoc[] array;
        private ScoreDoc pivot;

        private ScoreSorter() {
        }

        protected void swap(int i, int j) {
            ScoreDoc scoreDoc = this.array[i];
            this.array[i] = this.array[j];
            this.array[j] = scoreDoc;
        }

        protected int compare(int i, int j) {
            int cmp = Float.compare(this.array[j].score, this.array[i].score);
            return cmp == 0 ? QueryRescorer.compareDocId(this.array[i], this.array[j]) : cmp;
        }

        protected void setPivot(int i) {
            this.pivot = this.array[i];
        }

        protected int comparePivot(int j) {
            int cmp = Float.compare(this.array[j].score, this.pivot.score);
            return cmp == 0 ? QueryRescorer.compareDocId(this.pivot, this.array[j]) : cmp;
        }

        static /* synthetic */ ScoreDoc[] access$402(ScoreSorter x0, ScoreDoc[] x1) {
            x0.array = x1;
            return x1;
        }
    }

    private static final class DocIdSorter
    extends IntroSorter {
        private ScoreDoc[] array;
        private ScoreDoc pivot;

        private DocIdSorter() {
        }

        protected void swap(int i, int j) {
            ScoreDoc scoreDoc = this.array[i];
            this.array[i] = this.array[j];
            this.array[j] = scoreDoc;
        }

        protected int compare(int i, int j) {
            return QueryRescorer.compareDocId(this.array[i], this.array[j]);
        }

        protected void setPivot(int i) {
            this.pivot = this.array[i];
        }

        protected int comparePivot(int j) {
            return QueryRescorer.compareDocId(this.pivot, this.array[j]);
        }

        static /* synthetic */ ScoreDoc[] access$202(DocIdSorter x0, ScoreDoc[] x1) {
            x0.array = x1;
            return x1;
        }
    }

    public static class QueryRescoreContext
    extends RescoreSearchContext {
        private ParsedQuery parsedQuery;
        private float queryWeight = 1.0f;
        private float rescoreQueryWeight = 1.0f;
        private ScoreMode scoreMode = ScoreMode.Total;

        public QueryRescoreContext(QueryRescorer rescorer) {
            super(QueryRescorer.NAME, 10, rescorer);
        }

        public void setParsedQuery(ParsedQuery parsedQuery) {
            this.parsedQuery = parsedQuery;
        }

        public Query query() {
            return this.parsedQuery.query();
        }

        public float queryWeight() {
            return this.queryWeight;
        }

        public float rescoreQueryWeight() {
            return this.rescoreQueryWeight;
        }

        public ScoreMode scoreMode() {
            return this.scoreMode;
        }

        public void setRescoreQueryWeight(float rescoreQueryWeight) {
            this.rescoreQueryWeight = rescoreQueryWeight;
        }

        public void setQueryWeight(float queryWeight) {
            this.queryWeight = queryWeight;
        }

        public void setScoreMode(ScoreMode scoreMode) {
            this.scoreMode = scoreMode;
        }
    }

    private static enum ScoreMode {
        Avg{

            @Override
            public float combine(float primary, float secondary) {
                return (primary + secondary) / 2.0f;
            }

            public String toString() {
                return "avg";
            }
        }
        ,
        Max{

            @Override
            public float combine(float primary, float secondary) {
                return Math.max(primary, secondary);
            }

            public String toString() {
                return "max";
            }
        }
        ,
        Min{

            @Override
            public float combine(float primary, float secondary) {
                return Math.min(primary, secondary);
            }

            public String toString() {
                return "min";
            }
        }
        ,
        Total{

            @Override
            public float combine(float primary, float secondary) {
                return primary + secondary;
            }

            public String toString() {
                return "sum";
            }
        }
        ,
        Multiply{

            @Override
            public float combine(float primary, float secondary) {
                return primary * secondary;
            }

            public String toString() {
                return "product";
            }
        };


        public abstract float combine(float var1, float var2);
    }
}

