/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;

public class SubWidgetTagHandler
extends TagHandler {
    private static final Log log = LogFactory.getLog(SubWidgetTagHandler.class);
    protected final TagConfig config;

    public SubWidgetTagHandler(TagConfig config) {
        super(config);
        this.config = config;
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        Widget widget = null;
        FaceletHandlerHelper helper = new FaceletHandlerHelper(ctx, this.config);
        String widgetVariableName = RenderVariables.widgetVariables.widget.name();
        TagAttribute widgetAttribute = helper.createAttribute(widgetVariableName, String.format("#{%s}", widgetVariableName));
        if (widgetAttribute != null) {
            widget = (Widget)widgetAttribute.getObject(ctx, Widget.class);
        }
        if (widget == null) {
            log.error((Object)("Could not resolve widget " + widgetAttribute));
            return;
        }
        Widget[] subWidgets = widget.getSubWidgets();
        if (subWidgets == null || subWidgets.length == 0) {
            return;
        }
        int subWidgetCounter = 0;
        for (Widget subWidget : subWidgets) {
            HashMap<String, ValueExpression> variables = new HashMap<String, ValueExpression>();
            ExpressionFactory eFactory = ctx.getExpressionFactory();
            ValueExpression subWidgetVe = eFactory.createValueExpression((Object)subWidget, Widget.class);
            Integer level = null;
            String tagConfigId = null;
            if (subWidget != null) {
                level = subWidget.getLevel();
                tagConfigId = subWidget.getTagConfigId();
            }
            variables.put(RenderVariables.widgetVariables.widget.name(), subWidgetVe);
            ValueExpression subWidgetIndexVe = eFactory.createValueExpression((Object)subWidgetCounter, Integer.class);
            variables.put(RenderVariables.widgetVariables.widgetIndex.name(), subWidgetIndexVe);
            variables.put(String.format("%s_%s", RenderVariables.widgetVariables.widgetIndex.name(), level), subWidgetIndexVe);
            if (subWidget != null) {
                for (Map.Entry ctrl : subWidget.getControls().entrySet()) {
                    String key = (String)ctrl.getKey();
                    String name = String.format("%s_%s", RenderVariables.widgetVariables.widgetControl.name(), key);
                    Serializable value = (Serializable)ctrl.getValue();
                    variables.put(name, eFactory.createValueExpression((Object)value, Object.class));
                }
            }
            ArrayList<String> blockedPatterns = new ArrayList<String>();
            blockedPatterns.add(RenderVariables.widgetVariables.widget.name());
            blockedPatterns.add(RenderVariables.widgetVariables.widgetIndex.name() + "*");
            blockedPatterns.add(RenderVariables.widgetVariables.widgetControl.name() + "_*");
            FaceletHandler handlerWithVars = helper.getAliasTagHandler(tagConfigId, variables, blockedPatterns, this.nextHandler);
            handlerWithVars.apply(ctx, parent);
            ++subWidgetCounter;
        }
    }
}

