/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.io;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import yarfraw.core.datamodel.ChannelFeed;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.ItemEntry;
import yarfraw.core.datamodel.YarfrawException;
import yarfraw.io.FeedReader;
import yarfraw.io.FeedWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedAppender {
    private FeedWriter _writer;
    private FeedReader _reader;
    private int _numItemToKeep = -1;

    public FeedAppender(File file, FeedFormat format) {
        this._writer = new FeedWriter(file);
        this._reader = new FeedReader(file);
        this.setFormat(format);
    }

    public FeedAppender(String pathName, FeedFormat format) {
        this(new File(pathName), format);
    }

    public FeedAppender(URI uri, FeedFormat format) {
        this(new File(uri), format);
    }

    public FeedAppender(File file) {
        this(file, FeedFormat.RSS20);
    }

    public FeedAppender(String pathName) {
        this(new File(pathName), FeedFormat.RSS20);
    }

    public FeedAppender(URI uri) {
        this(new File(uri), FeedFormat.RSS20);
    }

    public FeedFormat getFormat() {
        return this._reader.getFormat();
    }

    public void setFormat(FeedFormat format) {
        if (format != null) {
            this._reader.setFormat(format);
            this._writer.setFormat(format);
        }
    }

    public int getNumItemToKeep() {
        return this._numItemToKeep;
    }

    public FeedAppender setNumItemToKeep(int numItemToKeep) {
        this._numItemToKeep = numItemToKeep < 0 ? -1 : numItemToKeep;
        return this;
    }

    private List<ItemEntry> trimItemsList(List<ItemEntry> items) {
        if (this._numItemToKeep != -1 && CollectionUtils.isNotEmpty(items) && items.size() > this._numItemToKeep) {
            return items.subList(0, this._numItemToKeep);
        }
        return items;
    }

    public FeedAppender appendAllItemsAt(int index, List<ItemEntry> items) throws YarfrawException {
        ChannelFeed ch = this.readChannel();
        List<ItemEntry> old = ch.getItems();
        if (old == null) {
            old = new ArrayList<ItemEntry>();
            ch.setItems(old);
        }
        old.addAll(index, items);
        ch.setItems(this.trimItemsList(old));
        this._writer = new FeedWriter(this._reader._file);
        this._writer.writeChannel(ch);
        return this;
    }

    public FeedAppender appendAllItemsToBeginning(List<ItemEntry> items) throws YarfrawException {
        return this.appendAllItemsAt(0, items);
    }

    public FeedAppender appendAllItemsToBeginning(ItemEntry ... items) throws YarfrawException {
        return this.appendAllItemsToBeginning(Arrays.asList(items));
    }

    public FeedAppender appendAllItemsToEnd(List<ItemEntry> items) throws YarfrawException {
        ChannelFeed ch = this.readChannel();
        List<ItemEntry> old = ch.getItems();
        if (old == null) {
            old = new ArrayList<ItemEntry>();
            ch.setItems(old);
        }
        old.addAll(items);
        ch.setItems(this.trimItemsList(old));
        this._writer = new FeedWriter(this._reader._file);
        this._writer.writeChannel(ch);
        return this;
    }

    public FeedAppender appendAllItemsToEnd(ItemEntry ... items) throws YarfrawException {
        return this.appendAllItemsToEnd(Arrays.asList(items));
    }

    public FeedAppender removeItem(int index) throws YarfrawException {
        ChannelFeed ch = this.readChannel();
        ch.getItems().remove(index);
        ch.setItems(this.trimItemsList(ch.getItems()));
        this._writer.writeChannel(ch);
        return this;
    }

    public FeedAppender setItem(int index, ItemEntry item) throws YarfrawException {
        ChannelFeed ch = this.readChannel();
        ch.getItems().set(index, item);
        this._writer.writeChannel(ch);
        return this;
    }

    private ChannelFeed readChannel() throws YarfrawException {
        ChannelFeed ch = this._reader.readChannel();
        if (ch.getItems() == null) {
            ch.setItems(new ArrayList<ItemEntry>());
        }
        return ch;
    }
}

