/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.mapping.forward.impl;

import java.math.BigInteger;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import yarfraw.core.datamodel.CategorySubject;
import yarfraw.core.datamodel.Content;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.Id;
import yarfraw.core.datamodel.Image;
import yarfraw.core.datamodel.ItemEntry;
import yarfraw.core.datamodel.Link;
import yarfraw.core.datamodel.Person;
import yarfraw.core.datamodel.Text;
import yarfraw.core.datamodel.YarfrawException;
import yarfraw.generated.atom10.elements.CategoryType;
import yarfraw.generated.atom10.elements.ContentType;
import yarfraw.generated.atom10.elements.DateTimeType;
import yarfraw.generated.atom10.elements.EntryType;
import yarfraw.generated.atom10.elements.IconType;
import yarfraw.generated.atom10.elements.IdType;
import yarfraw.generated.atom10.elements.LinkType;
import yarfraw.generated.atom10.elements.ObjectFactory;
import yarfraw.generated.atom10.elements.PersonType;
import yarfraw.generated.atom10.elements.TextType;
import yarfraw.generated.atom10.elements.UriType;
import yarfraw.utils.CommonUtils;

public class Atom10MappingUtils {
    private static final ObjectFactory FACTORY = new ObjectFactory();
    private static final Log LOG = LogFactory.getLog(Atom10MappingUtils.class);

    private Atom10MappingUtils() {
    }

    public static LinkType toLink(Link link) {
        LinkType ret = FACTORY.createLinkType();
        ret.setBase(link.getBase());
        ret.setLang(link.getLang());
        if (link.getOtherAttributes() != null) {
            ret.getOtherAttributes().putAll(link.getOtherAttributes());
        }
        ret.setHref(link.getHref());
        ret.setHreflang(link.getHreflang());
        ret.setLength(link.getLength() == null ? null : new BigInteger(String.valueOf(link.getLength())));
        ret.setRel(link.getRel());
        ret.setTitle(link.getTitle());
        ret.setType(link.getType());
        return ret;
    }

    public static PersonType toPersonType(Person p) {
        PersonType ret = new PersonType();
        if (p.getName() != null) {
            ret.getNameOrUriOrEmail().add(FACTORY.createPersonTypeName(p.getName()));
        }
        if (p.getEmailOrText() != null) {
            ret.getNameOrUriOrEmail().add(FACTORY.createPersonTypeEmail(p.getEmailOrText()));
        }
        if (p.getUri() != null) {
            UriType uri = FACTORY.createUriType();
            uri.setValue(p.getUri());
            ret.getNameOrUriOrEmail().add(FACTORY.createPersonTypeUri(uri));
        }
        if (p.getOtherElements() != null) {
            ret.getNameOrUriOrEmail().addAll(p.getOtherElements());
        }
        if (p.getOtherAttributes() != null) {
            ret.getOtherAttributes().putAll(p.getOtherAttributes());
        }
        ret.setBase(p.getBase());
        ret.setLang(p.getLang());
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    public static EntryType toEntry(ItemEntry item) throws YarfrawException {
        String newDateString;
        DateTimeType date;
        EntryType ret = FACTORY.createEntryType();
        List<Object> elementList = ret.getAuthorOrCategoryOrContent();
        ObjectFactory factory = FACTORY;
        if (item.getAuthorOrCreator() != null) {
            for (Person person : item.getAuthorOrCreator()) {
                elementList.add(factory.createEntryTypeAuthor(Atom10MappingUtils.toPersonType(person)));
            }
        }
        if (item.getCategorySubjects() != null) {
            for (CategorySubject categorySubject : item.getCategorySubjects()) {
                if (categorySubject == null) continue;
                elementList.add(factory.createEntryTypeCategory(Atom10MappingUtils.toCategoryType(categorySubject)));
            }
        }
        if (item.getContent() != null) {
            elementList.add(factory.createEntryTypeContent(Atom10MappingUtils.toContent(item.getContent())));
        }
        if (item.getContributors() != null) {
            for (Person person : item.getContributors()) {
                elementList.add(factory.createEntryTypeContributor(Atom10MappingUtils.toPersonType(person)));
            }
        }
        if (item.getUid() != null) {
            elementList.add(factory.createEntryTypeId(Atom10MappingUtils.toAtomId(item.getUid())));
        }
        if (item.getLinks() != null) {
            for (Link link : item.getLinks()) {
                elementList.add(factory.createEntryTypeLink(Atom10MappingUtils.toLink(link)));
            }
        }
        if (item.getPubDate() != null) {
            void var5_14;
            date = factory.createDateTimeType();
            String string = item.getPubDate();
            if (!CommonUtils.isDateFormatValid(string, FeedFormat.ATOM10)) {
                newDateString = CommonUtils.formatDate(CommonUtils.tryParseDate(string), FeedFormat.ATOM10);
                if (newDateString != null) {
                    String string2 = newDateString;
                } else {
                    LOG.warn((Object)("The dateString " + string + " is in valid according to Atom 1.0 specs, unabel to convert it to a valid format, writing it as is"));
                }
            }
            date.setValue((String)var5_14);
            elementList.add(factory.createEntryTypePublished(date));
        }
        if (item.getRights() != null) {
            elementList.add(factory.createEntryTypeRights(Atom10MappingUtils.toTextType(item.getRights())));
        }
        if (item.getDescriptionOrSummary() != null) {
            elementList.add(factory.createEntryTypeSummary(Atom10MappingUtils.toTextType(item.getDescriptionOrSummary())));
        }
        if (item.getComments() != null) {
            LOG.info((Object)"Item.Comments field is not supported by Atom 1.0. It will be ignored");
        }
        if (item.getTitle() != null) {
            elementList.add(factory.createEntryTypeTitle(Atom10MappingUtils.toTextType(item.getTitle())));
        }
        if (item.getUpdatedDate() != null) {
            void var5_18;
            date = factory.createDateTimeType();
            String string = item.getUpdatedDate();
            if (!CommonUtils.isDateFormatValid(string, FeedFormat.ATOM10)) {
                newDateString = CommonUtils.formatDate(CommonUtils.tryParseDate(string), FeedFormat.ATOM10);
                if (newDateString != null) {
                    String string3 = newDateString;
                } else {
                    LOG.warn((Object)("The dateString " + string + " is in valid according to Atom 1.0 specs, unabel to convert it to a valid format, writing it as is"));
                }
            }
            date.setValue((String)var5_18);
            elementList.add(factory.createEntryTypeUpdated(date));
        }
        if (item.getEnclosure() != null) {
            LOG.info((Object)"Item.Enclosure field is not supported by Atom 1.0. It will be ignored. Use Item.AtomLink to add enclosure element to item");
        }
        if (item.getSource() != null) {
            LOG.info((Object)"Item.Source field is not supported by Atom 1.0. It will be ignored");
        }
        if (item.getOtherElements() != null) {
            ret.getAuthorOrCategoryOrContent().addAll(item.getOtherElements());
        }
        if (item.getOtherAttributes() != null) {
            ret.getOtherAttributes().putAll(item.getOtherAttributes());
        }
        ret.setBase(item.getBase());
        ret.setLang(item.getLang());
        if (item.getOtherAttributes() != null) {
            ret.getOtherAttributes().putAll(item.getOtherAttributes());
        }
        return ret;
    }

    public static ContentType toContent(Content in) {
        ContentType ret = FACTORY.createContentType();
        ret.setSrc(in.getSrc());
        ret.setType(in.getType());
        if (in.getContentText() != null) {
            ret.getContent().addAll(in.getContentText());
        }
        if (in.getOtherElements() != null) {
            ret.getContent().addAll(in.getOtherElements());
        }
        if (in.getOtherAttributes() != null) {
            ret.getOtherAttributes().putAll(in.getOtherAttributes());
        }
        ret.setBase(in.getBase());
        ret.setLang(in.getLang());
        return ret;
    }

    public static IdType toAtomId(Id in) {
        IdType ret = FACTORY.createIdType();
        ret.setValue(in.getIdValue());
        if (in.getOtherAttributes() != null) {
            ret.getOtherAttributes().putAll(in.getOtherAttributes());
        }
        ret.setBase(in.getBase());
        ret.setLang(in.getLang());
        return ret;
    }

    public static CategoryType toCategoryType(CategorySubject in) {
        CategoryType ret = FACTORY.createCategoryType();
        ret.setTerm(in.getCategoryOrSubjectOrTerm());
        ret.setScheme(in.getDomainOrScheme());
        ret.setLabel(in.getLabel());
        if (in.getOtherAttributes() != null) {
            ret.getOtherAttributes().putAll(in.getOtherAttributes());
        }
        return ret;
    }

    public static TextType toTextType(Text in) {
        TextType ret = FACTORY.createTextType();
        if (in.getType() != null) {
            ret.setType(in.getType().toString());
        }
        if (in.getText() != null) {
            ret.getContent().add(in.getText());
        }
        if (in.getXhtmlDiv() != null) {
            ret.getContent().add(in.getXhtmlDiv());
        }
        if (in.getOtherElements() != null) {
            ret.getContent().addAll(in.getOtherElements());
        }
        if (in.getOtherAttributes() != null) {
            ret.getOtherAttributes().putAll(in.getOtherAttributes());
        }
        ret.setBase(in.getBase());
        ret.setLang(in.getLang());
        return ret;
    }

    public static IconType toIcon(Image in) {
        IconType ret = FACTORY.createIconType();
        ret.setValue(in.getUrl());
        if (in.getOtherAttributes() != null) {
            ret.getOtherAttributes().putAll(in.getOtherAttributes());
        }
        ret.setBase(in.getBase());
        ret.setLang(in.getLang());
        return ret;
    }
}

