/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.util.cdk;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.faces.FacesException;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;

public class MethodBindingToMethodExpression
extends MethodExpression
implements StateHolder {
    private static final Class[] EXPECTED_TYPES = new Class[]{MethodBinding.class, StateHolder.class};
    private MethodBinding methodBinding;
    private boolean _transientFlag;
    private transient MethodInfo methodInfo;

    protected MethodBindingToMethodExpression() {
    }

    public MethodBindingToMethodExpression(MethodBinding methodBinding) {
        this.checkNullArgument(methodBinding, "methodBinding");
        this.methodBinding = methodBinding;
    }

    public MethodBinding getMethodBinding() {
        return this.methodBinding;
    }

    void setMethodBinding(MethodBinding methodBinding) {
        this.methodBinding = methodBinding;
    }

    public MethodInfo getMethodInfo(ELContext context) throws PropertyNotFoundException, MethodNotFoundException, ELException {
        FacesContext facesContext;
        this.checkNullArgument(context, "elcontext");
        this.checkNullState(this.methodBinding, "methodBinding");
        if (this.methodInfo == null && (facesContext = (FacesContext)context.getContext(FacesContext.class)) != null) {
            this.methodInfo = this.invoke(new Invoker<MethodInfo>(){

                @Override
                public MethodInfo invoke() {
                    return new MethodInfo(null, MethodBindingToMethodExpression.this.methodBinding.getType(facesContext), null);
                }
            });
        }
        return this.methodInfo;
    }

    public Object invoke(ELContext context, final Object[] params) throws PropertyNotFoundException, MethodNotFoundException, ELException {
        this.checkNullArgument(context, "elcontext");
        this.checkNullState(this.methodBinding, "methodBinding");
        final FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
        if (facesContext != null) {
            return this.invoke(new Invoker<Object>(){

                @Override
                public Object invoke() {
                    return MethodBindingToMethodExpression.this.methodBinding.invoke(facesContext, params);
                }
            });
        }
        return null;
    }

    public boolean isLiteralText() {
        if (this.methodBinding == null) {
            throw new IllegalStateException("methodBinding is null");
        }
        String expr = this.methodBinding.getExpressionString();
        return !expr.startsWith("#{") || !expr.endsWith("}");
    }

    public String getExpressionString() {
        return this.methodBinding.getExpressionString();
    }

    public Object saveState(FacesContext context) {
        if (!this.isTransient()) {
            if (this.methodBinding instanceof StateHolder) {
                Object[] state = new Object[]{this.methodBinding.getClass().getName(), ((StateHolder)this.methodBinding).saveState(context)};
                return state;
            }
            return this.methodBinding;
        }
        return null;
    }

    public void restoreState(FacesContext context, Object state) {
        if (state instanceof MethodBinding) {
            this.methodBinding = (MethodBinding)state;
            this.methodInfo = null;
        } else if (state != null) {
            Object[] values = (Object[])state;
            this.methodBinding = (MethodBinding)MethodBindingToMethodExpression.newInstance(values[0].toString(), EXPECTED_TYPES);
            ((StateHolder)this.methodBinding).restoreState(context, values[1]);
            this.methodInfo = null;
        }
    }

    public void setTransient(boolean transientFlag) {
        this._transientFlag = transientFlag;
    }

    public boolean isTransient() {
        return this._transientFlag;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.methodBinding == null ? 0 : this.methodBinding.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MethodBindingToMethodExpression other = (MethodBindingToMethodExpression)((Object)obj);
        return !(this.methodBinding == null ? other.methodBinding != null : !this.methodBinding.equals(other.methodBinding));
    }

    private void checkNullState(Object notNullInstance, String instanceName) {
        if (notNullInstance == null) {
            throw new IllegalStateException(instanceName + " is null");
        }
    }

    private void checkNullArgument(Object notNullInstance, String instanceName) {
        if (notNullInstance == null) {
            throw new IllegalArgumentException(instanceName + " is null");
        }
    }

    private <T> T invoke(Invoker<T> invoker) {
        try {
            return invoker.invoke();
        }
        catch (javax.faces.el.MethodNotFoundException e) {
            throw new MethodNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (EvaluationException e) {
            throw new ELException(e.getMessage(), (Throwable)e);
        }
    }

    private static Object newInstance(String type, Class[] expectedTypes) {
        if (type == null) {
            return null;
        }
        Class clazzForName = MethodBindingToMethodExpression.simpleClassForName(type);
        if (expectedTypes != null) {
            int size = expectedTypes.length;
            for (int i = 0; i < size; ++i) {
                if (expectedTypes[i].isAssignableFrom(clazzForName)) continue;
                throw new FacesException("'" + type + "' does not implement expected type '" + expectedTypes[i] + "'");
            }
        }
        return MethodBindingToMethodExpression.newInstance(clazzForName);
    }

    private static Object newInstance(Class clazz) throws FacesException {
        try {
            return clazz.newInstance();
        }
        catch (NoClassDefFoundError e) {
            throw new FacesException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new FacesException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new FacesException((Throwable)e);
        }
    }

    private static Class classForName(String type) throws ClassNotFoundException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        try {
            return Class.forName(type, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException ignore) {
            return Class.forName(type, false, MethodBindingToMethodExpression.class.getClassLoader());
        }
    }

    private static Class simpleClassForName(String type) {
        try {
            return MethodBindingToMethodExpression.classForName(type);
        }
        catch (ClassNotFoundException e) {
            throw new FacesException((Throwable)e);
        }
    }

    private static interface Invoker<T> {
        public T invoke();
    }
}

