/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.persistence;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.ejb.transaction.JoinableCMTTransaction;
import org.hibernate.ejb.transaction.JoinableCMTTransactionFactory;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.JDBCTransactionFactory;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.transaction.TransactionManagerLookup;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.persistence.EntityManagerFactoryProvider;
import org.nuxeo.ecm.core.persistence.NuxeoConnectionProvider;
import org.nuxeo.ecm.core.persistence.PersistenceError;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.datasource.ConnectionHelper;
import org.nuxeo.runtime.datasource.DataSourceHelper;
import org.nuxeo.runtime.jtajca.NamingContextFactory;
import org.nuxeo.runtime.jtajca.NuxeoContainer;
import org.nuxeo.runtime.transaction.TransactionHelper;

@XObject(value="hibernateConfiguration")
public class HibernateConfiguration
implements EntityManagerFactoryProvider {
    public static final String RESOURCE_LOCAL = PersistenceUnitTransactionType.RESOURCE_LOCAL.name();
    public static final String JTA = PersistenceUnitTransactionType.JTA.name();
    public static final String TXTYPE_PROPERTY_NAME = "org.nuxeo.runtime.txType";
    private static final Log log = LogFactory.getLog(HibernateConfiguration.class);
    @XNode(value="@name")
    public String name;
    @XNodeMap(value="properties/property", key="@name", type=Properties.class, componentType=String.class)
    public final Properties hibernateProperties = new Properties();
    @XNodeList(value="classes/class", type=ArrayList.class, componentType=Class.class)
    public final List<Class<?>> annotedClasses = new ArrayList();
    protected Ejb3Configuration cfg;

    @XNode(value="datasource")
    public void setDatasource(String name) {
        String expandedValue = Framework.expandVars((String)name);
        if (expandedValue.startsWith("$")) {
            throw new PersistenceError("Cannot expand " + name + " for datasource");
        }
        this.hibernateProperties.put("hibernate.connection.datasource", DataSourceHelper.getDataSourceJNDIName((String)name));
    }

    public void addAnnotedClass(Class<?> annotedClass) {
        this.annotedClasses.add(annotedClass);
    }

    public void removeAnnotedClass(Class<?> annotedClass) {
        this.annotedClasses.remove(annotedClass);
    }

    public Ejb3Configuration setupConfiguration() {
        return this.setupConfiguration(null);
    }

    public Ejb3Configuration setupConfiguration(Map<String, String> properties) {
        this.cfg = new Ejb3Configuration();
        if (properties != null) {
            this.cfg.configure(this.name, properties);
        } else {
            this.cfg.configure(this.name, Collections.emptyMap());
        }
        this.cfg.addProperties(this.hibernateProperties);
        for (Class<?> annotedClass : this.annotedClasses) {
            this.cfg.addAnnotatedClass(annotedClass);
        }
        return this.cfg;
    }

    @Override
    public EntityManagerFactory getFactory(String txType) {
        Properties props;
        HashMap<String, String> properties = new HashMap<String, String>();
        if (txType == null) {
            txType = HibernateConfiguration.getTxType();
        }
        properties.put("javax.persistence.transactionType", txType);
        if (txType.equals(JTA)) {
            Class transactionFactoryClass = ConnectionHelper.useSingleConnection(null) ? NuxeoTransactionFactory.class : JoinableCMTTransactionFactory.class;
            properties.put("hibernate.transaction.factory_class", transactionFactoryClass.getName());
            properties.put("hibernate.transaction.manager_lookup_class", NuxeoTransactionManagerLookup.class.getName());
        } else if (txType.equals(RESOURCE_LOCAL)) {
            properties.put("hibernate.transaction.factory_class", JDBCTransactionFactory.class.getName());
        }
        if (this.cfg == null) {
            this.setupConfiguration(properties);
        }
        if ((props = this.cfg.getProperties()).get("hibernate.connection.url") == null) {
            props.put("hibernate.connection.provider_class", NuxeoConnectionProvider.class.getName());
        }
        if (txType.equals(RESOURCE_LOCAL)) {
            props.remove("hibernate.connection.datasource");
        } else {
            String dsname = props.getProperty("hibernate.connection.datasource");
            dsname = DataSourceHelper.getDataSourceJNDIName((String)dsname);
            props.put("hibernate.connection.datasource", dsname);
            props.put("hibernate.jndi.class", NamingContextFactory.class.getName());
            props.put("hibernate.jndi".concat(".").concat("java.naming.factory.url.pkgs"), NuxeoContainer.class.getPackage().getName());
        }
        return this.createEntityManagerFactory(properties);
    }

    protected EntityManagerFactory createEntityManagerFactory(final Map<String, String> properties) {
        final EntityManagerFactory[] emf = new EntityManagerFactory[1];
        Thread t = new Thread("persistence-init-" + this.name){

            @Override
            public void run() {
                emf[0] = HibernateConfiguration.this.cfg.createEntityManagerFactory(properties);
            }
        };
        try {
            t.start();
            t.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return emf[0];
    }

    @Override
    public EntityManagerFactory getFactory() {
        return this.getFactory(null);
    }

    public static String getTxType() {
        String txType;
        if (Framework.isInitialized()) {
            txType = Framework.getProperty((String)TXTYPE_PROPERTY_NAME);
            if (txType == null) {
                try {
                    TransactionHelper.lookupTransactionManager();
                    txType = JTA;
                }
                catch (NamingException e) {
                    txType = RESOURCE_LOCAL;
                }
            }
        } else {
            txType = RESOURCE_LOCAL;
        }
        return txType;
    }

    public static HibernateConfiguration load(URL location) {
        XMap map = new XMap();
        map.register(HibernateConfiguration.class);
        try {
            return (HibernateConfiguration)map.load(location);
        }
        catch (Exception e) {
            throw new PersistenceError("Cannot load hibernate configuration from " + location, e);
        }
    }

    public void merge(HibernateConfiguration other) {
        assert (this.name.equals(other.name)) : " cannot merge configuration that do not have the same persistence unit";
        this.annotedClasses.addAll(other.annotedClasses);
        this.hibernateProperties.clear();
        this.hibernateProperties.putAll((Map<?, ?>)other.hibernateProperties);
    }

    public static class NuxeoTransactionManagerLookup
    implements TransactionManagerLookup {
        public NuxeoTransactionManagerLookup() {
            try {
                TransactionHelper.lookupUserTransaction();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }

        public TransactionManager getTransactionManager(Properties props) {
            try {
                return TransactionHelper.lookupTransactionManager();
            }
            catch (NamingException e) {
                throw new HibernateException(e.getMessage(), (Throwable)e);
            }
        }

        public String getUserTransactionName() {
            return TransactionHelper.getUserTransactionJNDIName();
        }

        public Object getTransactionIdentifier(Transaction transaction) {
            return transaction;
        }
    }

    public static class NuxeoHibernateTransaction
    extends JoinableCMTTransaction {
        public NuxeoHibernateTransaction(JDBCContext jdbcContext, TransactionFactory.Context transactionContext) {
            super(jdbcContext, transactionContext);
        }

        public void registerSynchronization(Synchronization sync) throws HibernateException {
            boolean registered;
            try {
                registered = ConnectionHelper.registerSynchronization((Synchronization)sync);
            }
            catch (SystemException e) {
                throw new HibernateException((Throwable)e);
            }
            if (!registered) {
                super.registerSynchronization(sync);
            }
        }
    }

    public static class NuxeoTransactionFactory
    extends JoinableCMTTransactionFactory {
        public ConnectionReleaseMode getDefaultReleaseMode() {
            return ConnectionReleaseMode.AFTER_TRANSACTION;
        }

        public org.hibernate.Transaction createTransaction(JDBCContext jdbcContext, TransactionFactory.Context transactionContext) throws HibernateException {
            return new NuxeoHibernateTransaction(jdbcContext, transactionContext);
        }
    }
}

