/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.xml.atom;

import com.google.api.client.googleapis.xml.atom.GoogleAtom;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.xml.AbstractXmlHttpContent;
import com.google.api.client.xml.XmlNamespaceDictionary;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import org.xmlpull.v1.XmlSerializer;

public final class AtomPatchRelativeToOriginalContent
extends AbstractXmlHttpContent {
    private final Object patchedEntry;
    private final Object originalEntry;

    public AtomPatchRelativeToOriginalContent(XmlNamespaceDictionary namespaceDictionary, Object originalEntry, Object patchedEntry) {
        super(namespaceDictionary);
        this.originalEntry = Preconditions.checkNotNull((Object)originalEntry);
        this.patchedEntry = Preconditions.checkNotNull((Object)patchedEntry);
    }

    protected void writeTo(XmlSerializer serializer) throws IOException {
        Map<String, Object> patch = GoogleAtom.computePatch(this.patchedEntry, this.originalEntry);
        this.getNamespaceDictionary().serialize(serializer, "http://www.w3.org/2005/Atom", "entry", patch);
    }

    public AtomPatchRelativeToOriginalContent setMediaType(HttpMediaType mediaType) {
        super.setMediaType(mediaType);
        return this;
    }

    public final Object getPatchedEntry() {
        return this.patchedEntry;
    }

    public final Object getOriginalEntry() {
        return this.originalEntry;
    }
}

