/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.retry;

import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.redis.retry.Retry;

public class SimpleDelay
implements Retry.Policy {
    protected final int base;
    protected final long delay;
    protected int elapsed;

    public SimpleDelay(int base, int delay) {
        this.base = base;
        this.delay = TimeUnit.MILLISECONDS.convert(delay, TimeUnit.SECONDS);
    }

    @Override
    public boolean allow() {
        return (long)this.elapsed < this.delay;
    }

    @Override
    public void pause() {
        long computed = this.computeDelay();
        LogFactory.getLog(SimpleDelay.class).warn((Object)("pausing for " + computed + " ms"));
        try {
            Thread.sleep(computed);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.elapsed = (int)((long)this.elapsed + computed);
    }

    protected long computeDelay() {
        return this.base;
    }
}

