/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.codec;

import com.phloc.commons.codec.DecoderException;
import com.phloc.commons.codec.EncoderException;
import com.phloc.commons.codec.ICodec;
import com.phloc.commons.codec.LZWDecodeDictionary;
import com.phloc.commons.codec.LZWEncodeDictionary;
import com.phloc.commons.codec.LZWNode;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.io.streams.BitInputStream;
import com.phloc.commons.io.streams.BitOutputStream;
import com.phloc.commons.io.streams.NonBlockingByteArrayInputStream;
import com.phloc.commons.io.streams.NonBlockingByteArrayOutputStream;
import com.phloc.commons.io.streams.StreamUtils;
import java.io.EOFException;
import java.io.IOException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LZWCodec
implements ICodec {
    private static final Logger s_aLogger = LoggerFactory.getLogger(LZWCodec.class);

    @Override
    @Nullable
    public byte[] decode(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        BitInputStream bitInputStream = new BitInputStream(new NonBlockingByteArrayInputStream(byArray), true);
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
        LZWDecodeDictionary lZWDecodeDictionary = new LZWDecodeDictionary();
        lZWDecodeDictionary.reset();
        try {
            byte[] byArray2;
            int n = lZWDecodeDictionary.readCode(bitInputStream);
            while (n == 256) {
                n = lZWDecodeDictionary.readCode(bitInputStream);
            }
            if (n != 257) {
                byArray2 = lZWDecodeDictionary.getBytes(n);
                if (byArray2 == null) {
                    throw new DecoderException("Failed to resolve initial code " + n);
                }
                nonBlockingByteArrayOutputStream.write(byArray2);
                byte[] byArray3 = byArray2;
                while ((n = lZWDecodeDictionary.readCode(bitInputStream)) != 257) {
                    if (n == 256) {
                        lZWDecodeDictionary.reset();
                        n = lZWDecodeDictionary.readCode(bitInputStream);
                        if (n == 257) break;
                        byArray2 = lZWDecodeDictionary.getBytes(n);
                        nonBlockingByteArrayOutputStream.write(byArray2);
                        byArray3 = byArray2;
                        continue;
                    }
                    int n2 = lZWDecodeDictionary.getNextFreeCode();
                    if (n < n2) {
                        byArray2 = lZWDecodeDictionary.getBytes(n);
                    } else if (n == n2) {
                        byArray2 = ArrayHelper.getConcatenated(byArray3, byArray3[0]);
                    } else {
                        throw new DecoderException("Error decoding LZW: unexpected code " + n + " while next free code is " + n2);
                    }
                    nonBlockingByteArrayOutputStream.write(byArray2);
                    lZWDecodeDictionary.addString(ArrayHelper.getConcatenated(byArray3, byArray2[0]), false);
                    byArray3 = byArray2;
                }
            }
            byArray2 = nonBlockingByteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (EOFException eOFException) {
            throw new DecoderException("Unexpected EOF decoding LZW", eOFException);
        }
        catch (IOException iOException) {
            throw new DecoderException("Error decoding LZW", iOException);
        }
        finally {
            StreamUtils.close(bitInputStream);
            StreamUtils.close(nonBlockingByteArrayOutputStream);
        }
    }

    @Override
    @Nullable
    public byte[] encode(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
        BitOutputStream bitOutputStream = new BitOutputStream(nonBlockingByteArrayOutputStream, true);
        LZWEncodeDictionary lZWEncodeDictionary = new LZWEncodeDictionary();
        lZWEncodeDictionary.reset();
        try {
            int n;
            bitOutputStream.writeBits(256, lZWEncodeDictionary.getCodeLength());
            byte[] byArray2 = new byte[]{};
            for (n = 0; n < byArray.length; ++n) {
                byte by = byArray[n];
                byArray2 = ArrayHelper.getConcatenated(byArray2, by);
                lZWEncodeDictionary.visit(by);
                int n2 = lZWEncodeDictionary.getCodeLength();
                LZWNode lZWNode = lZWEncodeDictionary.getNode(byArray2);
                if (n + 1 == byArray.length) {
                    bitOutputStream.writeBits(lZWNode.getTableIndex(), n2);
                    break;
                }
                if (lZWNode.getChildNode(byArray[n + 1]) == null) {
                    bitOutputStream.writeBits(lZWNode.getTableIndex(), n2);
                    byArray2 = new byte[]{};
                }
                if (lZWEncodeDictionary.getNextFreeCode() != 4095) continue;
                bitOutputStream.writeBits(256, n2);
                lZWEncodeDictionary.reset();
                n -= byArray2.length;
                byArray2 = new byte[]{};
            }
            n = lZWEncodeDictionary.getCodeLength();
            switch (lZWEncodeDictionary.getNextFreeCode()) {
                case 511: 
                case 1023: 
                case 2047: {
                    s_aLogger.info("EOF char gets a new code length: " + ++n);
                    break;
                }
            }
            bitOutputStream.writeBits(257, n);
        }
        catch (IOException iOException) {
            throw new EncoderException("Error encoding LZW", iOException);
        }
        finally {
            StreamUtils.close(bitOutputStream);
        }
        return nonBlockingByteArrayOutputStream.toByteArray();
    }
}

