/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.iterate;

import com.phloc.commons.string.ToStringGenerator;
import java.util.Enumeration;
import java.util.Iterator;
import javax.annotation.Nonnull;

public final class EnumerationFromIterator<ELEMENTTYPE>
implements Enumeration<ELEMENTTYPE> {
    private final Iterator<ELEMENTTYPE> m_aIter;

    public EnumerationFromIterator(@Nonnull Iterable<ELEMENTTYPE> iterable) {
        this(iterable.iterator());
    }

    public EnumerationFromIterator(@Nonnull Iterator<ELEMENTTYPE> iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        this.m_aIter = iterator;
    }

    @Override
    public boolean hasMoreElements() {
        return this.m_aIter.hasNext();
    }

    @Override
    public ELEMENTTYPE nextElement() {
        return this.m_aIter.next();
    }

    public String toString() {
        return new ToStringGenerator(this).append("iter", this.m_aIter).toString();
    }

    @Nonnull
    public static <ELEMENTTYPE> EnumerationFromIterator<ELEMENTTYPE> create(@Nonnull Iterator<ELEMENTTYPE> iterator) {
        return new EnumerationFromIterator<ELEMENTTYPE>(iterator);
    }

    @Nonnull
    public static <ELEMENTTYPE> EnumerationFromIterator<ELEMENTTYPE> create(@Nonnull Iterable<ELEMENTTYPE> iterable) {
        return new EnumerationFromIterator<ELEMENTTYPE>(iterable);
    }
}

