/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.gfx;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.math.IHasWidthAndHeight;
import com.phloc.commons.math.MathHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ScalableSize
implements IHasWidthAndHeight,
Serializable {
    private final int m_nWidth;
    private final int m_nHeight;

    public ScalableSize(@Nonnull IHasWidthAndHeight iHasWidthAndHeight) {
        this(iHasWidthAndHeight.getWidth(), iHasWidthAndHeight.getHeight());
    }

    public ScalableSize(@Nonnegative int n, @Nonnegative int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Width may not be < 0: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Height may not be < 0: " + n2);
        }
        this.m_nWidth = n;
        this.m_nHeight = n2;
    }

    @Override
    @Nonnegative
    public int getWidth() {
        return this.m_nWidth;
    }

    @Override
    @Nonnegative
    public int getHeight() {
        return this.m_nHeight;
    }

    @Nonnull
    @CheckReturnValue
    public ScalableSize getBestMatchingSize(@Nonnegative int n, @Nonnegative int n2) {
        double d;
        if (n < 1) {
            throw new IllegalArgumentException("Passed width value is not allowed: " + n);
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Passed height value is not allowed: " + n2);
        }
        double d2 = MathHelper.getDividedDouble(this.m_nWidth, n);
        if (d2 > (d = MathHelper.getDividedDouble(this.m_nHeight, n2))) {
            if (this.m_nWidth > n) {
                return new ScalableSize(n, (int)((double)this.m_nHeight / d2));
            }
        } else if (this.m_nHeight > n2) {
            return new ScalableSize((int)((double)this.m_nWidth / d), n2);
        }
        return this;
    }

    @Nonnull
    @CheckReturnValue
    public ScalableSize getScaledToWidth(@Nonnegative int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Passed width value is not allowed: " + n);
        }
        if (this.m_nWidth == n) {
            return this;
        }
        double d = MathHelper.getDividedDouble(n, this.m_nWidth);
        return new ScalableSize(n, (int)((double)this.m_nHeight * d));
    }

    @Nonnull
    @CheckReturnValue
    public ScalableSize getScaledToHeight(@Nonnegative int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Passed height value is not allowed: " + n);
        }
        if (this.m_nHeight == n) {
            return this;
        }
        double d = MathHelper.getDividedDouble(n, this.m_nHeight);
        return new ScalableSize((int)((double)this.m_nWidth * d), n);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ScalableSize)) {
            return false;
        }
        ScalableSize scalableSize = (ScalableSize)object;
        return this.m_nWidth == scalableSize.m_nWidth && this.m_nHeight == scalableSize.m_nHeight;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nWidth).append(this.m_nHeight).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("width", this.m_nWidth).append("height", this.m_nHeight).toString();
    }
}

