/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.io.streams.WrappedInputStream;
import com.phloc.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugInputStream
extends WrappedInputStream {
    private static final Logger s_aLogger = LoggerFactory.getLogger(DebugInputStream.class);
    private long m_nPosition = 0L;

    public DebugInputStream(@Nonnull InputStream inputStream) {
        super(inputStream);
    }

    public final long getPosition() {
        return this.m_nPosition;
    }

    @OverrideOnDemand
    protected void onRead(int n, long l) {
        s_aLogger.info("Read " + n + " byte(s); now at " + l);
    }

    @OverrideOnDemand
    protected void onSkip(long l, long l2) {
        s_aLogger.info("Skipped " + l + " byte(s); now at " + l2);
    }

    @Override
    public final int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            ++this.m_nPosition;
            this.onRead(1, this.m_nPosition);
        }
        return n;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            this.m_nPosition += (long)n3;
            this.onRead(n3, this.m_nPosition);
        }
        return n3;
    }

    @Override
    public final long skip(@Nonnegative long l) throws IOException {
        long l2 = super.skip(l);
        if (l2 > 0L) {
            this.m_nPosition += l2;
            this.onSkip(l2, this.m_nPosition);
        }
        return l2;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("position", this.m_nPosition).toString();
    }
}

