/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.log;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.error.EErrorLevel;
import com.phloc.commons.error.IHasErrorLevel;
import com.phloc.commons.state.IErrorIndicator;
import com.phloc.commons.state.ISuccessIndicator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class LogMessage
implements IHasErrorLevel,
ISuccessIndicator,
IErrorIndicator {
    private final Date m_aIssueDT;
    private final EErrorLevel m_eErrorLevel;
    private final Object m_aMsg;
    private final Throwable m_aThrowable;

    public LogMessage(@Nonnull EErrorLevel eErrorLevel, @Nonnull Object object, @Nullable Throwable throwable) {
        if (eErrorLevel == null) {
            throw new NullPointerException("level");
        }
        if (object == null) {
            throw new NullPointerException("msg");
        }
        this.m_aIssueDT = new Date();
        this.m_eErrorLevel = eErrorLevel;
        this.m_aMsg = object;
        this.m_aThrowable = throwable;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Date getIssueDateTime() {
        return (Date)this.m_aIssueDT.clone();
    }

    @Override
    @Nonnull
    public EErrorLevel getErrorLevel() {
        return this.m_eErrorLevel;
    }

    @Nonnull
    public Object getMessage() {
        return this.m_aMsg;
    }

    @Nullable
    public Throwable getThrowable() {
        return this.m_aThrowable;
    }

    @Override
    public boolean isSuccess() {
        return this.m_eErrorLevel.isSuccess();
    }

    @Override
    public boolean isFailure() {
        return this.m_eErrorLevel.isFailure();
    }

    @Override
    public boolean isError() {
        return this.m_eErrorLevel.isError();
    }

    @Override
    public boolean isNoError() {
        return this.m_eErrorLevel.isNoError();
    }

    public String toString() {
        return new ToStringGenerator(this).append("issueDT", this.m_aIssueDT).append("errorLevel", this.m_eErrorLevel).append("msg", this.m_aMsg).appendIfNotNull("throwable", this.m_aThrowable).toString();
    }
}

