/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.impl;

import com.phloc.commons.microdom.EMicroNodeType;
import com.phloc.commons.microdom.IMicroDocument;
import com.phloc.commons.microdom.IMicroDocumentType;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.MicroException;
import com.phloc.commons.microdom.impl.AbstractMicroNode;
import com.phloc.commons.microdom.impl.AbstractMicroNodeWithChildren;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MicroDocument
extends AbstractMicroNodeWithChildren
implements IMicroDocument {
    public MicroDocument() {
    }

    public MicroDocument(@Nullable IMicroDocumentType iMicroDocumentType) {
        if (iMicroDocumentType != null) {
            this.appendChild(iMicroDocumentType);
        }
    }

    @Override
    @Nonnull
    public EMicroNodeType getType() {
        return EMicroNodeType.DOCUMENT;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    private static boolean _canBeAppendedToDocumentRoot(@Nonnull IMicroNode iMicroNode) {
        return iMicroNode.isDocumentType() || iMicroNode.isProcessingInstruction() || iMicroNode.isComment() || iMicroNode.isElement();
    }

    @Override
    protected void onAppendChild(@Nonnull AbstractMicroNode abstractMicroNode) {
        if (!MicroDocument._canBeAppendedToDocumentRoot(abstractMicroNode)) {
            throw new MicroException("Cannot add nodes of type " + abstractMicroNode + " to a document");
        }
        if (abstractMicroNode.isElement() && this.directGetChildren() != null && !this.directGetChildren().isEmpty()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (!iMicroNode.isElement()) continue;
                throw new MicroException("A document can only have one document element! Already has " + iMicroNode + " and wants to add " + abstractMicroNode);
            }
        }
        super.onAppendChild(abstractMicroNode);
    }

    @Override
    public boolean isStandalone() {
        if (this.getDocType() != null) {
            return false;
        }
        IMicroElement iMicroElement = this.getDocumentElement();
        if (iMicroElement != null && iMicroElement.hasAttributes()) {
            for (Map.Entry<String, String> entry : iMicroElement.getAttributes().entrySet()) {
                String string = entry.getKey();
                if (!string.startsWith("xmlns:") || !entry.getValue().equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
                String string2 = string.substring("xmlns:".length());
                return iMicroElement.getAttribute(string2 + ":schemaLocation") == null;
            }
        }
        return true;
    }

    @Override
    @Nullable
    public IMicroDocumentType getDocType() {
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (!iMicroNode.isDocumentType()) continue;
                return (IMicroDocumentType)iMicroNode;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IMicroElement getDocumentElement() {
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (!iMicroNode.isElement()) continue;
                return (IMicroElement)iMicroNode;
            }
        }
        return null;
    }

    @Override
    @Nonnull
    public IMicroDocument getClone() {
        MicroDocument microDocument = new MicroDocument();
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.getChildren()) {
                microDocument.appendChild((IMicroNode)iMicroNode.getClone());
            }
        }
        return microDocument;
    }
}

