/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.impl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.microdom.EMicroNodeType;
import com.phloc.commons.microdom.IMicroEntityReference;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.impl.AbstractMicroNode;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MicroEntityReference
extends AbstractMicroNode
implements IMicroEntityReference {
    private final String m_sName;

    public MicroEntityReference(@Nonnull @Nonempty String string) {
        if (StringHelper.hasNoText(string)) {
            throw new IllegalArgumentException("The passed entity reference name is invalid");
        }
        this.m_sName = string;
    }

    @Override
    @Nonnull
    public EMicroNodeType getType() {
        return EMicroNodeType.ENTITY_REFERENCE;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNodeName() {
        return '&' + this.m_sName + ';';
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNodeValue() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public IMicroEntityReference getClone() {
        return new MicroEntityReference(this.m_sName);
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        if (iMicroNode == this) {
            return true;
        }
        if (!(iMicroNode instanceof MicroEntityReference)) {
            return false;
        }
        MicroEntityReference microEntityReference = (MicroEntityReference)iMicroNode;
        return this.m_sName.equals(microEntityReference.m_sName);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("name", this.m_sName).toString();
    }
}

