/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.regex;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.RegEx;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class RegExPattern {
    private static final AtomicBoolean s_aCheckConsistencyEnabled = new AtomicBoolean(false);
    private final String m_sRegEx;
    private final int m_nOptions;
    private Pattern m_aPattern;
    private Integer m_aHashCode;

    public static void checkPatternConsistency(@Nonnull @RegEx String string) throws IllegalArgumentException {
        int n = 0;
        while (n >= 0) {
            if ((n = string.indexOf(36, n)) == -1) continue;
            if (!(n == string.length() - 1 || Character.isDigit(string.charAt(n + 1)) || n + 1 < string.length() && string.charAt(n + 1) == ')' || n > 0 && string.charAt(n - 1) == '\\')) {
                throw new IllegalArgumentException("The passed regex '" + string + "' contains an unquoted '$' sign at index " + n + "!");
            }
            ++n;
        }
    }

    public RegExPattern(@Nonnull @RegEx @Nonempty String string) {
        this(string, 0);
    }

    public RegExPattern(@Nonnull @RegEx @Nonempty String string, @Nonnegative int n) {
        if (StringHelper.hasNoText(string)) {
            throw new IllegalArgumentException("regEx is empty");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Options may not be < 0: " + n);
        }
        this.m_sRegEx = string;
        this.m_nOptions = n;
        if (RegExPattern.areDebugConsistencyChecksEnabled()) {
            RegExPattern.checkPatternConsistency(string);
        }
        try {
            this.m_aPattern = Pattern.compile(this.m_sRegEx, this.m_nOptions);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Regular expression '" + this.m_sRegEx + "' is illegal" + (this.m_nOptions == 0 ? "" : " with options " + this.m_nOptions), patternSyntaxException);
        }
    }

    @Nonnull
    @RegEx
    @Nonempty
    public String getRegEx() {
        return this.m_sRegEx;
    }

    @Nonnegative
    public int getOptions() {
        return this.m_nOptions;
    }

    @Nonnull
    public Pattern getAsPattern() {
        return this.m_aPattern;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RegExPattern)) {
            return false;
        }
        RegExPattern regExPattern = (RegExPattern)object;
        return this.m_sRegEx.equals(regExPattern.m_sRegEx) && this.m_nOptions == regExPattern.m_nOptions;
    }

    public int hashCode() {
        if (this.m_aHashCode == null) {
            this.m_aHashCode = new HashCodeGenerator(this).append(this.m_sRegEx).append(this.m_nOptions).getHashCodeObj();
        }
        return this.m_aHashCode;
    }

    public String toString() {
        return new ToStringGenerator(this).append("regex", this.m_sRegEx).append("options", this.m_nOptions).toString();
    }

    public static boolean areDebugConsistencyChecksEnabled() {
        return s_aCheckConsistencyEnabled.get();
    }

    public static void enableDebugConsistencyChecks(boolean bl) {
        s_aCheckConsistencyEnabled.set(bl);
    }
}

