/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.utils.xml;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.convert.MicroTypeConverter;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.tree.utils.xml.IConverterTreeXML;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MicroTypeConverterTreeXML<DATATYPE>
implements IConverterTreeXML<DATATYPE> {
    private String m_sNamespaceURI;
    private final String m_sElementName;
    private final Class<? extends DATATYPE> m_aNativeClass;

    public MicroTypeConverterTreeXML(@Nonnull @Nonempty String string, @Nonnull Class<? extends DATATYPE> clazz) {
        this(null, string, clazz);
    }

    public MicroTypeConverterTreeXML(@Nullable String string, @Nonnull @Nonempty String string2, @Nonnull Class<? extends DATATYPE> clazz) {
        if (StringHelper.hasNoText(string2)) {
            throw new IllegalArgumentException("elementName");
        }
        if (clazz == null) {
            throw new NullPointerException("nativeClass");
        }
        this.m_sNamespaceURI = string;
        this.m_sElementName = string2;
        this.m_aNativeClass = clazz;
    }

    @Override
    public void appendDataValue(@Nonnull IMicroElement iMicroElement, @Nullable DATATYPE DATATYPE) {
        iMicroElement.appendChild(MicroTypeConverter.convertToMicroElement(DATATYPE, this.m_sNamespaceURI, this.m_sElementName));
    }

    @Override
    @Nullable
    public DATATYPE getAsDataValue(@Nonnull IMicroElement iMicroElement) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement();
        if (iMicroElement2 != null) {
            if (!EqualsUtils.equals(this.m_sNamespaceURI, iMicroElement2.getNamespaceURI())) {
                throw new IllegalStateException("Namespace mismatch! Expected: " + this.m_sNamespaceURI);
            }
            if (!this.m_sElementName.equals(iMicroElement2.getTagName())) {
                throw new IllegalStateException("Tag name mismatch! Expected: " + this.m_sElementName);
            }
        }
        return MicroTypeConverter.convertToNative(iMicroElement2, this.m_aNativeClass);
    }

    @Nonnull
    public static <DATATYPE> MicroTypeConverterTreeXML<DATATYPE> create(@Nonnull @Nonempty String string, @Nonnull Class<? extends DATATYPE> clazz) {
        return new MicroTypeConverterTreeXML<DATATYPE>(string, clazz);
    }

    @Nonnull
    public static <DATATYPE> MicroTypeConverterTreeXML<DATATYPE> create(@Nullable String string, @Nonnull @Nonempty String string2, @Nonnull Class<? extends DATATYPE> clazz) {
        return new MicroTypeConverterTreeXML<DATATYPE>(string, string2, clazz);
    }
}

