/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.withid.unique;

import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.tree.withid.ITreeItemWithID;
import com.phloc.commons.tree.withid.unique.ITreeItemWithUniqueIDFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractTreeItemWithUniqueIDFactory<KEYTYPE, VALUETYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE>>
implements ITreeItemWithUniqueIDFactory<KEYTYPE, VALUETYPE, ITEMTYPE> {
    private final Map<KEYTYPE, ITEMTYPE> m_aItemStore;

    public AbstractTreeItemWithUniqueIDFactory() {
        this(new HashMap());
    }

    public AbstractTreeItemWithUniqueIDFactory(@Nonnull Map<KEYTYPE, ITEMTYPE> map) {
        if (map == null) {
            throw new NullPointerException("itemStore");
        }
        this.m_aItemStore = map;
    }

    @Nonnull
    protected final ITEMTYPE addToItemStore(@Nonnull KEYTYPE KEYTYPE, @Nonnull ITEMTYPE ITEMTYPE) {
        if (this.m_aItemStore.containsKey(KEYTYPE)) {
            throw new IllegalArgumentException("An item with ID '" + KEYTYPE + "' is already contained!");
        }
        this.m_aItemStore.put(KEYTYPE, ITEMTYPE);
        return ITEMTYPE;
    }

    @Nonnull
    protected abstract ITEMTYPE internalCreate(@Nonnull ITEMTYPE var1, @Nonnull KEYTYPE var2);

    @Nonnull
    @OverrideOnDemand
    protected KEYTYPE internalGetItemID(@Nonnull ITEMTYPE ITEMTYPE) {
        return ITEMTYPE.getID();
    }

    @Override
    @Nonnull
    public final ITEMTYPE create(@Nonnull ITEMTYPE ITEMTYPE, @Nonnull KEYTYPE KEYTYPE) {
        if (ITEMTYPE == null) {
            throw new NullPointerException("parent may not be null - use createRoot instead!");
        }
        ITEMTYPE ITEMTYPE2 = this.internalCreate(ITEMTYPE, KEYTYPE);
        return this.addToItemStore(this.internalGetItemID(ITEMTYPE2), ITEMTYPE2);
    }

    @Override
    public final void onRemoveItem(@Nonnull ITEMTYPE ITEMTYPE) {
        this.m_aItemStore.remove(this.internalGetItemID(ITEMTYPE));
    }

    @Override
    public final void onAddItem(@Nonnull ITEMTYPE ITEMTYPE) {
        this.addToItemStore(this.internalGetItemID(ITEMTYPE), ITEMTYPE);
    }

    @Override
    @Nullable
    public final ITEMTYPE getItemOfDataID(@Nullable KEYTYPE KEYTYPE) {
        return (ITEMTYPE)((ITreeItemWithID)this.m_aItemStore.get(KEYTYPE));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final Collection<ITEMTYPE> getAllItems() {
        return ContainerHelper.newList(this.m_aItemStore.values());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractTreeItemWithUniqueIDFactory abstractTreeItemWithUniqueIDFactory = (AbstractTreeItemWithUniqueIDFactory)object;
        return ((Object)this.m_aItemStore).equals(abstractTreeItemWithUniqueIDFactory.m_aItemStore);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Map)this.m_aItemStore)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("itemStoreKeys", this.m_aItemStore.keySet()).toString();
    }
}

