/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.serialize;

import com.phloc.commons.CGlobal;
import com.phloc.commons.microdom.IMicroDocumentType;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.DefaultXMLIterationHandler;
import com.phloc.commons.xml.EXMLIncorrectCharacterHandling;
import com.phloc.commons.xml.EXMLVersion;
import com.phloc.commons.xml.XMLHelper;
import com.phloc.commons.xml.serialize.HTMLdtd;
import com.phloc.commons.xml.serialize.IXMLWriterSettings;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class XMLEmitterPhloc
extends DefaultXMLIterationHandler {
    public static final boolean DEFAULT_THROW_EXCEPTION_ON_NESTED_COMMENTS = true;
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String COMMENT_START = "<!--";
    private static final String COMMENT_END = "-->";
    private static final char ER_START = '&';
    private static final char ER_END = ';';
    private static final String PI_START = "<?";
    private static final String PI_END = "?>";
    private static final String CRLF = CGlobal.LINE_SEPARATOR;
    private static boolean s_bThrowExceptionOnNestedComments = true;
    private final Writer m_aWriter;
    private final IXMLWriterSettings m_aSettings;
    private EXMLVersion m_eXMLVersion = EXMLVersion.DEFAULT;
    private final char m_cTextBoundary;

    public XMLEmitterPhloc(@Nonnull @WillNotClose Writer writer, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        if (writer == null) {
            throw new NullPointerException("writer");
        }
        if (iXMLWriterSettings == null) {
            throw new NullPointerException("settings");
        }
        this.m_aWriter = writer;
        this.m_aSettings = iXMLWriterSettings;
        this.m_cTextBoundary = (char)(iXMLWriterSettings.isUseDoubleQuotesForAttributes() ? 34 : 39);
    }

    public static void setThrowExceptionOnNestedComments(boolean bl) {
        s_bThrowExceptionOnNestedComments = bl;
    }

    public static boolean isThrowExceptionOnNestedComments() {
        return s_bThrowExceptionOnNestedComments;
    }

    @Nonnull
    private XMLEmitterPhloc _append(@Nonnull String string) {
        try {
            this.m_aWriter.write(string);
            return this;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @Nonnull
    private XMLEmitterPhloc _append(char c) {
        try {
            this.m_aWriter.write(c);
            return this;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @Nonnull
    private XMLEmitterPhloc _appendMasked(@Nullable String string) {
        try {
            XMLHelper.maskXMLTextTo(this.m_eXMLVersion, this.m_aSettings.getIncorrectCharacterHandling(), string, this.m_aWriter);
            return this;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @Nonnull
    private XMLEmitterPhloc _appendAttrValue(@Nullable String string) {
        return this._append(this.m_cTextBoundary)._appendMasked(string)._append(this.m_cTextBoundary);
    }

    @Override
    public void onDocumentStart(@Nullable EXMLVersion eXMLVersion, @Nullable String string, boolean bl) {
        if (eXMLVersion != null) {
            this.m_eXMLVersion = eXMLVersion;
        }
        this._append(PI_START)._append("xml version=")._appendAttrValue(this.m_eXMLVersion.getVersion());
        if (string != null) {
            this._append(" encoding=")._appendAttrValue(string);
        }
        if (bl) {
            this._append(" standalone=")._appendAttrValue("yes");
        }
        this._append(PI_END)._append(CRLF);
    }

    @Nonnull
    public static String getDocTypeHTMLRepresentation(@Nonnull EXMLVersion eXMLVersion, @Nonnull EXMLIncorrectCharacterHandling eXMLIncorrectCharacterHandling, @Nonnull IMicroDocumentType iMicroDocumentType) {
        return XMLEmitterPhloc.getDocTypeHTMLRepresentation(eXMLVersion, eXMLIncorrectCharacterHandling, iMicroDocumentType.getQualifiedName(), iMicroDocumentType.getPublicID(), iMicroDocumentType.getSystemID());
    }

    @Nonnull
    public static String getDocTypeHTMLRepresentation(@Nonnull EXMLVersion eXMLVersion, @Nonnull EXMLIncorrectCharacterHandling eXMLIncorrectCharacterHandling, @Nonnull String string, @Nullable String string2, @Nullable String string3) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("<!DOCTYPE ").append(string);
        if (string2 != null && string3 != null) {
            stringBuilder.append(" PUBLIC \"").append(XMLHelper.getMaskedXMLText(eXMLVersion, eXMLIncorrectCharacterHandling, string2)).append("\" \"").append(XMLHelper.getMaskedXMLText(eXMLVersion, eXMLIncorrectCharacterHandling, string3)).append('\"');
        } else if (string3 != null) {
            stringBuilder.append(" SYSTEM \"").append(XMLHelper.getMaskedXMLText(eXMLVersion, eXMLIncorrectCharacterHandling, string3)).append('\"');
        }
        return stringBuilder.append('>').append(CRLF).toString();
    }

    @Override
    public void onDocumentType(@Nonnull String string, @Nullable String string2, @Nullable String string3) {
        if (string == null) {
            throw new NullPointerException("qualifiedElementName");
        }
        String string4 = XMLEmitterPhloc.getDocTypeHTMLRepresentation(this.m_eXMLVersion, this.m_aSettings.getIncorrectCharacterHandling(), string, string2, string3);
        this._append(string4);
    }

    @Override
    public void onProcessingInstruction(@Nonnull String string, @Nullable String string2) {
        this._append(PI_START)._append(string);
        if (StringHelper.hasText(string2)) {
            this._append(' ')._append(string2);
        }
        this._append(PI_END)._append(CRLF);
    }

    @Override
    public void onEntityReference(@Nonnull String string) {
        this._append('&')._append(string)._append(';');
    }

    @Override
    public void onContentElementWhitespace(@Nullable CharSequence charSequence) {
        if (StringHelper.hasText(charSequence)) {
            this._append(((Object)charSequence).toString());
        }
    }

    @Override
    public void onComment(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            if (XMLEmitterPhloc.isThrowExceptionOnNestedComments() && (string.contains(COMMENT_START) || string.contains(COMMENT_END))) {
                throw new IllegalArgumentException("XML comment contains nested XML comment: " + string);
            }
            this._append(COMMENT_START)._append(string)._append(COMMENT_END);
        }
    }

    @Override
    public void onText(@Nullable String string, boolean bl) {
        if (bl) {
            this._appendMasked(string);
        } else {
            this._append(string);
        }
    }

    @Override
    public void onCDATA(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            List<String> list = StringHelper.getExploded(CDATA_END, string);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this._append(CDATA_START)._append(list.get(i))._append(CDATA_END);
                if (i >= n - 1) continue;
                this._appendMasked(CDATA_END);
            }
        }
    }

    @Override
    public void onElementStart(@Nullable String string, @Nonnull String string2, @Nullable Map<String, String> map, boolean bl) {
        this._append('<');
        if (StringHelper.hasText(string)) {
            this._append(string)._append(':');
        }
        this._append(string2);
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string3 = entry.getKey();
                String string4 = entry.getValue();
                this._append(' ')._append(string3)._append('=')._appendAttrValue(string4);
            }
        }
        if (this.m_aSettings.getFormat().isHTML()) {
            this._append('>');
        } else {
            this._append(bl ? ">" : (this.m_aSettings.isSpaceOnSelfClosedElement() ? " />" : "/>"));
        }
    }

    @Override
    public void onElementEnd(@Nullable String string, @Nonnull String string2, boolean bl) {
        boolean bl2 = this.m_aSettings.getFormat().isHTML() ? bl || !HTMLdtd.isEmptyTag(string2) : bl;
        if (bl2) {
            this._append("</");
            if (StringHelper.hasText(string)) {
                this._append(string)._append(':');
            }
            this._append(string2)._append('>');
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("writer", this.m_aWriter).append("settings", this.m_aSettings).append("version", this.m_eXMLVersion).toString();
    }
}

