/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.BooleanCollection;
import org.apache.commons.collections.primitives.BooleanIterator;

public abstract class AbstractBooleanCollection
implements BooleanCollection {
    protected AbstractBooleanCollection() {
    }

    @Override
    @Nonnull
    public abstract BooleanIterator iterator();

    @Override
    @Nonnegative
    public abstract int size();

    @Override
    public boolean add(boolean bl) {
        throw new UnsupportedOperationException("add(boolean) is not supported.");
    }

    @Override
    public boolean addAll(@Nonnull BooleanCollection booleanCollection) {
        boolean bl = false;
        BooleanIterator booleanIterator = booleanCollection.iterator();
        while (booleanIterator.hasNext()) {
            bl |= this.add(booleanIterator.next());
        }
        return bl;
    }

    @Override
    public void clear() {
        BooleanIterator booleanIterator = this.iterator();
        while (booleanIterator.hasNext()) {
            booleanIterator.next();
            booleanIterator.remove();
        }
    }

    @Override
    public boolean contains(boolean bl) {
        BooleanIterator booleanIterator = this.iterator();
        while (booleanIterator.hasNext()) {
            if (booleanIterator.next() != bl) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@Nonnull BooleanCollection booleanCollection) {
        BooleanIterator booleanIterator = booleanCollection.iterator();
        while (booleanIterator.hasNext()) {
            if (this.contains(booleanIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size();
    }

    @Override
    public boolean removeElement(boolean bl) {
        BooleanIterator booleanIterator = this.iterator();
        while (booleanIterator.hasNext()) {
            if (booleanIterator.next() != bl) continue;
            booleanIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(@Nonnull BooleanCollection booleanCollection) {
        boolean bl = false;
        BooleanIterator booleanIterator = booleanCollection.iterator();
        while (booleanIterator.hasNext()) {
            bl |= this.removeElement(booleanIterator.next());
        }
        return bl;
    }

    @Override
    public boolean retainAll(@Nonnull BooleanCollection booleanCollection) {
        boolean bl = false;
        BooleanIterator booleanIterator = this.iterator();
        while (booleanIterator.hasNext()) {
            if (booleanCollection.contains(booleanIterator.next())) continue;
            booleanIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public boolean[] toArray() {
        boolean[] blArray = new boolean[this.size()];
        int n = 0;
        BooleanIterator booleanIterator = this.iterator();
        while (booleanIterator.hasNext()) {
            blArray[n++] = booleanIterator.next();
        }
        return blArray;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public boolean[] toArray(@Nonnull boolean[] blArray) {
        if (blArray.length < this.size()) {
            return this.toArray();
        }
        int n = 0;
        BooleanIterator booleanIterator = this.iterator();
        while (booleanIterator.hasNext()) {
            blArray[n++] = booleanIterator.next();
        }
        return blArray;
    }
}

