/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.ShortCollection;
import org.apache.commons.collections.primitives.ShortIterator;

public abstract class AbstractShortCollection
implements ShortCollection {
    protected AbstractShortCollection() {
    }

    @Override
    @Nonnull
    public abstract ShortIterator iterator();

    @Override
    @Nonnegative
    public abstract int size();

    @Override
    public boolean add(short s) {
        throw new UnsupportedOperationException("add(short) is not supported.");
    }

    @Override
    public boolean addAll(@Nonnull ShortCollection shortCollection) {
        boolean bl = false;
        ShortIterator shortIterator = shortCollection.iterator();
        while (shortIterator.hasNext()) {
            bl |= this.add(shortIterator.next());
        }
        return bl;
    }

    @Override
    public void clear() {
        ShortIterator shortIterator = this.iterator();
        while (shortIterator.hasNext()) {
            shortIterator.next();
            shortIterator.remove();
        }
    }

    @Override
    public boolean contains(short s) {
        ShortIterator shortIterator = this.iterator();
        while (shortIterator.hasNext()) {
            if (shortIterator.next() != s) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@Nonnull ShortCollection shortCollection) {
        ShortIterator shortIterator = shortCollection.iterator();
        while (shortIterator.hasNext()) {
            if (this.contains(shortIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size();
    }

    @Override
    public boolean removeElement(short s) {
        ShortIterator shortIterator = this.iterator();
        while (shortIterator.hasNext()) {
            if (shortIterator.next() != s) continue;
            shortIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(@Nonnull ShortCollection shortCollection) {
        boolean bl = false;
        ShortIterator shortIterator = shortCollection.iterator();
        while (shortIterator.hasNext()) {
            bl |= this.removeElement(shortIterator.next());
        }
        return bl;
    }

    @Override
    public boolean retainAll(@Nonnull ShortCollection shortCollection) {
        boolean bl = false;
        ShortIterator shortIterator = this.iterator();
        while (shortIterator.hasNext()) {
            if (shortCollection.contains(shortIterator.next())) continue;
            shortIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public short[] toArray() {
        short[] sArray = new short[this.size()];
        int n = 0;
        ShortIterator shortIterator = this.iterator();
        while (shortIterator.hasNext()) {
            sArray[n++] = shortIterator.next();
        }
        return sArray;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public short[] toArray(@Nonnull short[] sArray) {
        if (sArray.length < this.size()) {
            return this.toArray();
        }
        int n = 0;
        ShortIterator shortIterator = this.iterator();
        while (shortIterator.hasNext()) {
            sArray[n++] = shortIterator.next();
        }
        return sArray;
    }
}

