/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.BooleanCollection;
import org.apache.commons.collections.primitives.BooleanIterator;
import org.apache.commons.collections.primitives.RandomAccessBooleanList;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class ArrayBooleanList
extends RandomAccessBooleanList
implements Serializable {
    private transient boolean[] _data;
    private int _size;

    public ArrayBooleanList() {
        this(8);
    }

    public ArrayBooleanList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity " + n);
        }
        this._data = new boolean[n];
        this._size = 0;
    }

    public ArrayBooleanList(@Nonnull BooleanCollection booleanCollection) {
        this(booleanCollection.size());
        this.addAll(booleanCollection);
    }

    public ArrayBooleanList(@Nonnull boolean[] blArray) {
        this(blArray.length);
        System.arraycopy(blArray, 0, this._data, 0, blArray.length);
        this._size = blArray.length;
    }

    @Override
    public boolean get(int n) {
        this._checkRange(n);
        return this._data[n];
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public boolean removeElementAt(int n) {
        this._checkRange(n);
        this.incrModCount();
        boolean bl = this._data[n];
        int n2 = this._size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this._data, n + 1, this._data, n, n2);
        }
        --this._size;
        return bl;
    }

    @Override
    public boolean set(int n, boolean bl) {
        this._checkRange(n);
        this.incrModCount();
        boolean bl2 = this._data[n];
        this._data[n] = bl;
        return bl2;
    }

    @Override
    public void add(int n, boolean bl) {
        this._checkRangeIncludingEndpoint(n);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int n2 = this._size - n;
        System.arraycopy(this._data, n, this._data, n + 1, n2);
        this._data[n] = bl;
        ++this._size;
    }

    @Override
    public void clear() {
        this.incrModCount();
        this._size = 0;
    }

    @Override
    public boolean addAll(@Nonnull BooleanCollection booleanCollection) {
        return this.addAll(this.size(), booleanCollection);
    }

    @Override
    public boolean addAll(int n, @Nonnull BooleanCollection booleanCollection) {
        if (booleanCollection.size() == 0) {
            return false;
        }
        int n2 = n;
        this._checkRangeIncludingEndpoint(n2);
        this.incrModCount();
        this.ensureCapacity(this._size + booleanCollection.size());
        if (n2 != this._size) {
            System.arraycopy(this._data, n2, this._data, n2 + booleanCollection.size(), this._size - n2);
        }
        BooleanIterator booleanIterator = booleanCollection.iterator();
        while (booleanIterator.hasNext()) {
            this._data[n2] = booleanIterator.next();
            ++n2;
        }
        this._size += booleanCollection.size();
        return true;
    }

    public void ensureCapacity(int n) {
        this.incrModCount();
        if (n > this._data.length) {
            int n2 = this._data.length * 3 / 2 + 1;
            boolean[] blArray = this._data;
            this._data = new boolean[n2 < n ? n : n2];
            System.arraycopy(blArray, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            boolean[] blArray = this._data;
            this._data = new boolean[this._size];
            System.arraycopy(blArray, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._data.length);
        for (int i = 0; i < this._size; ++i) {
            objectOutputStream.writeBoolean(this._data[i]);
        }
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._data = new boolean[objectInputStream.readInt()];
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = objectInputStream.readBoolean();
        }
    }

    private final void _checkRange(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + n);
        }
    }

    private final void _checkRangeIncludingEndpoint(int n) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + n);
        }
    }
}

