/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.RandomAccessShortList;
import org.apache.commons.collections.primitives.ShortCollection;
import org.apache.commons.collections.primitives.ShortIterator;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class ArrayShortList
extends RandomAccessShortList
implements Serializable {
    private transient short[] _data;
    private int _size;

    public ArrayShortList() {
        this(8);
    }

    public ArrayShortList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity " + n);
        }
        this._data = new short[n];
        this._size = 0;
    }

    public ArrayShortList(@Nonnull ShortCollection shortCollection) {
        this(shortCollection.size());
        this.addAll(shortCollection);
    }

    public ArrayShortList(@Nonnull short[] sArray) {
        this(sArray.length);
        System.arraycopy(sArray, 0, this._data, 0, sArray.length);
        this._size = sArray.length;
    }

    @Override
    public short get(int n) {
        this._checkRange(n);
        return this._data[n];
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public short removeElementAt(int n) {
        this._checkRange(n);
        this.incrModCount();
        short s = this._data[n];
        int n2 = this._size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this._data, n + 1, this._data, n, n2);
        }
        --this._size;
        return s;
    }

    @Override
    public short set(int n, short s) {
        this._checkRange(n);
        this.incrModCount();
        short s2 = this._data[n];
        this._data[n] = s;
        return s2;
    }

    @Override
    public void add(int n, short s) {
        this._checkRangeIncludingEndpoint(n);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int n2 = this._size - n;
        System.arraycopy(this._data, n, this._data, n + 1, n2);
        this._data[n] = s;
        ++this._size;
    }

    @Override
    public void clear() {
        this.incrModCount();
        this._size = 0;
    }

    @Override
    public boolean addAll(@Nonnull ShortCollection shortCollection) {
        return this.addAll(this.size(), shortCollection);
    }

    @Override
    public boolean addAll(int n, @Nonnull ShortCollection shortCollection) {
        if (shortCollection.size() == 0) {
            return false;
        }
        int n2 = n;
        this._checkRangeIncludingEndpoint(n2);
        this.incrModCount();
        this.ensureCapacity(this._size + shortCollection.size());
        if (n2 != this._size) {
            System.arraycopy(this._data, n2, this._data, n2 + shortCollection.size(), this._size - n2);
        }
        ShortIterator shortIterator = shortCollection.iterator();
        while (shortIterator.hasNext()) {
            this._data[n2] = shortIterator.next();
            ++n2;
        }
        this._size += shortCollection.size();
        return true;
    }

    public void ensureCapacity(int n) {
        this.incrModCount();
        if (n > this._data.length) {
            int n2 = this._data.length * 3 / 2 + 1;
            short[] sArray = this._data;
            this._data = new short[n2 < n ? n : n2];
            System.arraycopy(sArray, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            short[] sArray = this._data;
            this._data = new short[this._size];
            System.arraycopy(sArray, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._data.length);
        for (int i = 0; i < this._size; ++i) {
            objectOutputStream.writeShort(this._data[i]);
        }
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._data = new short[objectInputStream.readInt()];
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = objectInputStream.readShort();
        }
    }

    private final void _checkRange(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + n);
        }
    }

    private final void _checkRangeIncludingEndpoint(int n) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + n);
        }
    }
}

